<?php

namespace IZON\MVC\View\Resolvers;

use Exception;

use IZON\Logs\Logger;

use \IZON\MVC\View\Resolvers\ViewResolver;
use \IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class PHPViewResolver implements ViewResolver {
    
    protected $viewsDir = __BASE_DIR__ ."/views";
    
    
    /**
     * @var string dir containing libraries for use in view 
     */
    protected $librariesDir = NULL;

    /**
     * @var string files containing libraries used for rendering the view
     */
    protected $librariesFiles = [];
    
    /**
     * @var array
     */
    protected $staticContentConfig = [];
    
    /**
     *
     * @var Logger 
     */
    protected $log = NULL;
    
    
    function __construct($config = []) {
        if( isset($config["librariesDir"] ) ) {
            $this->librariesDir = $config["librariesDir"];
        }
        
        if( isset($config["staticContent"]) ) {
            $this->staticContentConfig = $config["staticContent"];
        }
        
        $this->log = Logger::getLogger(self::class);
    }

    
    public function buildView($viewName) {
        $this->log->info("Trying to resolve view $viewName");
        
        // nepouziva view
        if( !file_exists( $this->viewsDir ."/". $viewName . PHPView::VIEW_SUFFIX ) ) {
            return NULL;
        }
        
        $view = new PHPView($viewName, $this->viewsDir, $this->librariesDir, $this->staticContentConfig);
        
        return $view;
    }
    
    /**
     * returns info which files to minify
     * @return array
     */
    public function getStaticContentToMinify() {
        $sourceDir = $this->staticContentConfig["staticContentDir"];
        if( !file_exists($sourceDir)
           || !is_dir($sourceDir) ) {
            return [];
        }
        $targetDir = $this->staticContentConfig["minifiedContentDir"];
        if( !file_exists($targetDir)
           || !is_dir($targetDir) ) {
            return [];
        }
        
        $jsDirsToMinify = $this->staticContentConfig["jsDirsToMinify"];
        $contentToMinify = [];
        foreach($jsDirsToMinify as $jsSourceDir) {
            $jsFullSourceDir = $sourceDir ."/". $jsSourceDir;
            if( file_exists($jsFullSourceDir)
                && is_dir($jsFullSourceDir) ) {
                $contentToMinify[] = ["sourceDir" => $jsFullSourceDir, "targetDir" => $targetDir ."/". $jsSourceDir, "type" => "js"];
            }
        }
        
        return $contentToMinify;
    }
}
