<?php

namespace IZON\MVC\Exceptions\Handlers;

use \IZON\Logs\LogLevel;
use \IZON\MVC\Exceptions\PageNotFoundException;

/**
 * Handles if page is not found
 */
class PageNotFoundExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow = "www/errors/404.php";

    /**
     * PageNotFoundExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to PageNotFound Page (file)
     */
    public function __construct($htmlToShow = "www/errors/404.php") {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException($exception) {
        header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found');
        require __BASE_DIR__. '/'. $this->htmlToShow;
    }

    public function isFor($exception) {
        return $exception instanceof PageNotFoundException;
    }
}
