<?php

namespace IZON\MVC\Routers;

use \Exception;

use IZON\Utils\Locale;

use IZON\MVC\HttpRequest;
use IZON\MVC\PageInfo;
use IZON\MVC\Context\WebContext;

use IZON\MVC\Interceptors\PageInfoInterceptor;


/**
 * Definice routovani nacitana z pole
 */
class ArrayRouteDefinition implements RouteDefinition {
    
    /**
     * contains array of arrays with routing informations
     * @var array 
     */
    
    protected $defaultInverseRoutes = [];
    
    
    protected $routes = []; 

    /**
     * interceptory vazane na jednotlive controllery
     * pole poli, klic je uid controlleru 
     * a hodnota je pole s id jednotlivych controlleru
     * @var array 
     */
    protected $controllerInterceptors = [];
    
    
    public function __construct(array $routingTable) {
        $this->routes = $routingTable;
        
        // initialize routers srray
//        foreach ($this->defaultRoutes as $route) {
//            $controllerUid = $route['controller_uid'];
//            $this->defaultInverseRoutes[$controllerUid] = $route;
//        }
    }
    
    /**
     * prida routovani specificke pro dane locale
     * @param string $locale
     * @param array $routes
     */
//    public function addLocaleRoutes($locale, $routes) {
//        $this->routes[$locale] = $routes;
//    }
    
    public function findRoute(HttpRequest $request) {
        $routes = NULL;
        // ma talove locale, routuj podle neho
        if( isset($this->routes[ mb_strtolower($request->getLocale()->getCountry()) ]) ) {
            $routes = $this->routes[mb_strtolower($request->getLocale()->getCountry())];
        } else {
            throw new Exception("No routing table for locale ". $request->getLocale()->getCountry());
        }
        
        foreach($routes as $route) {
            $urlPattern = $route['url'];
//            echo $urlPattern ." ". $request->getUrl();
            $matches = [];
//            preg_match('/(?P<word>t[^s]+)/',$test,$matches);
            if( preg_match('#'. $urlPattern .'#', $request->getUrl(), $matches) ) {  // reqexp musi byt obalen delimiterem
                $parameters = $matches;
                unset($parameters[0]);
                
                // prekopirovat parametry z adresy do $request
                foreach($parameters as $key => $value) {
                    if( !is_numeric($key) ) { // numeric values represent index of match, we dont need them as we bind reqex values to names
                        $request->addParameter($key, $value);
                    }
                }
                
                // pridava informace o strance ziskane z routovacich 
                $pageInfo = $this->createPageInfo($route);
                $parameters[PageInfo::PAGE_INFO_INDENTIFIER] = $pageInfo;
                
                $routeInfo = new RouteInfo();
                $routeInfo->setUrl($request->getUrl());
                $routeInfo->setPattern($urlPattern);
                $routeInfo->setContrlollerId($route['controller_uid']);
                $routeInfo->setParameters($parameters);
                
                // add context to page
                $context = new WebContext($request->getSession(), $pageInfo);
                $routeInfo->setContext($context);
                
                $interceptors = [new PageInfoInterceptor()];
//                if( isset($this->controllerInterceptors[$row['controller_uid']]) ) {
//                    $interceptors = array_merge($interceptors, $this->controllerInterceptors[$row['controller_uid']]);
//                }
                
                $routeInfo->setInterceptors($interceptors);
                
                return $routeInfo;
            }
        }
        return NULL;
    }

    public function findURL($controllerId, array $parameters, $methodName, Locale $locale) {
        // FIXME: impelentovat
        if( !isset( $inverseRoutes[$controllerId] ) ) { // routig not found
            return NULL;
        }
        
        $route = $inverseRoutes[$controllerId];
        // TODO: spetny preklad routy
        
        return NULL;
    }

    /**
     * 
     * @param array $row array containing pageinfo
     * @return PageInfo informace o strance ziskane z db
     */
    protected function createPageInfo(array $row) {
        $pageInfo = new PageInfo();
        
        $pageInfo->setTitle($row["title"]);
        $pageInfo->setDesctiprion($row["description"]);
        $pageInfo->setKeywords($row["keywords"]);
        $pageInfo->setRobots($row["robots"]);
                
        return $pageInfo;
    }
    
    /**
     * nastavuje interceptory jen pro specificke controllery
     * @param array $interceptors pole poli kde klicem je identifier controlleru a hodnota je pole interceptoru, ktere se na nem maji provezt
     */
    function setControllerInterceptors(array $interceptors) {
        $this->controllerInterceptors = $interceptors;
    }
    
    /**
     * adds ides of interceptors to be called around $controllerId
     * @param string $controllerId
     * @param string[] $interceptorIdes
     * @throws Exception
     */
    function addControllerInterceptors($controllerId, array $interceptorIdes) {
        if( array_key_exists($controllerId, $this->controllerInterceptors) ) {
            throw new Exception("Interceptors for controller $controllerId already added.");
        }
        $this->controllerInterceptors[$controllerId] = $interceptorIdes;
    }
}
