<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\DI\MVC;

use \Exception;


if (! function_exists('IZON\DI\MVC\appSubDir')) {
    /**
     * Vraci adresar relativne k adresari aplikace
     */
    function appSubDir($relativeDir)
    {
        return \DI\string("{". \IZON\MVC\Config::APP_DIR_IDENTIFIER ."}". $relativeDir);
    }
}

if (! function_exists('IZON\DI\MVC\tmpSubDir')) {
    /**
     * Vraci adresar relativne k tmp adresari
     */
    function tmpSubDir($relativeDir)
    {
        return \DI\string("{". \IZON\MVC\Config::TMP_DIR_IDENTIFIER ."}". $relativeDir);
    }
}

if (! function_exists('IZON\DI\MVC\cacheSubDir')) {
    /**
     * Vraci adresar relativne k adresari cache
     */
    function cacheSubDir($relativeDir) {
        return \DI\string("{". \IZON\MVC\Config::CACHE_DIR_IDENTIFIER ."}". $relativeDir);
    }
}