<?php

namespace IZON\MVC\Tests;

use PHPUnit\Framework\TestCase;

use IZON\DB\DBConnection;
use IZON\MVC\Routers\DBRouteDefinition2;

/**
 * @covers DBRouteDefinition2
 */
class DBRouteDefinition2Test extends TestCase {
    
    /**
     * @var DBConnection 
     */
    protected $dbConnection;
    
    /**
     * @var DBRouteDefinition2 
     */
    protected $routeDefinition;

            
    public function setUp() {
        $this->dbConnection = $this->createMock(DBConnection::class);
        $this->routeDefinition = new DBRouteDefinition2($this->dbConnection);
    }
    
    public function testAddControlerInterceptors() {
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller2", ["interceptor1", "interceptor2"]);
    }
    
    public function testAddDupliciteControlerInterceptors() {
        $this->expectException(\Exception::class);
        
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        
    }
}
