<?php

namespace IZON\MVC\Tests;

use PHPUnit\Framework\TestCase;

use IZON\DB\DBConnection;
use IZON\MVC\Routers\ArrayRouteDefinition;

/**
 * @covers ArrayRouteDefinition
 */
class ArrayRouteDefinitionTest extends TestCase {
    
    /**
     * @var ArrayRouteDefinition 
     */
    protected $routeDefinition;

            
    public function setUp() {
        $this->routeDefinition = new ArrayRouteDefinition([]);
    }
    
    public function testAddControlerInterceptors() {
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller2", ["interceptor1", "interceptor2"]);
    }
    
    public function testAddDupliciteControlerInterceptors() {
        $this->expectException(\Exception::class);
        
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        
    }
}
