<?php

namespace IZON\MVC\View;

use Exception;

use \IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class PHPLayoutView extends PHPView {

    const PART_SUFFIX = ".tmpl.php";
    
    const LAYOUT_SUFFIX = ".lay.php";

    private $layoutName;

    private $layoutsDir;


    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($layoutName, $layoutsDir, $viewName, $viewsDir, $librariesDir, $librariesFiles, $staticContentConfig = []) {
        parent::__construct($viewName, $viewsDir, $librariesDir, $librariesFiles, $staticContentConfig);
        // TODO test na existenci layoutu a adresare s view
        $this->layoutName = $layoutName;
        $this->layoutsDir = $layoutsDir;
    }

    function getLayoutName() {
        return $this->layoutName;
    }

    /**
     * provede vykresleni celeho view
     */
    function render() {
        // load view libraries
        if( $this->librariesDir != NULL ) { // some library dir is set
            foreach(scandir($this->librariesDir) as $file) {
                if( \IZON\String\endsWith($file, ".php") ) {
                    require_once $this->librariesDir ."/". $file;
                }
            }
        }
        // nacte pozadovany layout
        $this->requireFile($this->findLayoutFilePath());
    }

    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    function renderLayoutPart($partName, $sameDirectory = FALSE) {
        if( $sameDirectory ) {
            $partFileName = $this->viewsDir ."/". $this->viewName ."/". $partName . self::PART_SUFFIX;
            if( !file_exists($partFileName) ) {
                throw new Exception("");
            }
        } else {
            $partFilePath = $this->findLayoutPartFilePath($partName);
            if( $partFilePath == NULL ) {
                throw new Exception("Pro view ". $this->viewName ." neexistuje layoutPart ". $partName);
            }
            
            // TODO tady bude test jestli se vubec nejaky soubor nasel
            $this->requireFile($partFilePath);
        }
    }

    /**
     * @param $partName
     * @return string - absolute path
     */
    private function findLayoutPartFilePath($partName) {
        $layoutPartFolder = $this->getLayoutPartFolder();
        //
        if (file_exists(WEB_ROOT_DIR . $layoutPartFolder . $partName . "." . $this->getLang() . self::PART_SUFFIX)) {
            return $layoutPartFolder . $partName . "." . $this->getLang() . self::PART_SUFFIX;
        } else if (file_exists(WEB_ROOT_DIR . $layoutPartFolder . $partName . self::PART_SUFFIX)) {
            return $layoutPartFolder . $partName . self::PART_SUFFIX;
        } else {
            $dirsArray = explode("/", $this->getLayoutPartFolder());
            for ($i = count($dirsArray) - 1; $i >= 0; $i--) {
                $dir = $this->createSubdir($dirsArray, $i);
                if (file_exists( $dir . $partName . "." . $this->getLang() . self::PART_SUFFIX)) {
                    return $dir . $partName . "." . $this->getLang() . self::PART_SUFFIX;
                } elseif (file_exists( $dir . $partName . self::PART_SUFFIX)) {
                    return $dir . $partName . self::PART_SUFFIX;
                }
            }
        }
        // TODO pridat pred priponu jeste $this->getLang() pro rozliseni pri internacionalizaci
    }

    /**
     * vytvoti cestu k podadresari podle polozek v poli a poctu polozek, ktere se maji\
     * pozit
     */
    private function createSubdir($subdirsArray, $count) {
        return implode('/', array_slice($subdirsArray, 0, $count)) . '/';
    }

    // TODO: vracet to co se nastavi ve viewResolveru
    private function findLayoutFilePath() {
        return $this->layoutsDir . "/" . $this->layoutName . self::LAYOUT_SUFFIX;
    }

    // TODO: vracet to co se nastavi ve viewResolveru
    private function getLayoutPartFolder() {
        return $this->viewsDir ."/" . $this->viewName . "/";
    }

    /**
     * Load file by require
     * @param $filename absolute path
     * @throws Exception
     */
    function requireFile($filename) {
       $fileDir = $filename;
//       var_dump($fileDir);
    //    echo $filename ." file-exists: ". file_exists($fileDir) ."</br> ". $filename;
       if (empty($filename)) {
           throw new Exception("path-constants > requireFileOnce: argument \$filename is empty.");
       } else {
           if(!file_exists($fileDir) || $filename == '') {
               //echo "<span style=\"color:red\">Soubor '". $fileDir ."' neexistuje</span>";
               throw new Exception("path-constants > requireFileOnce: file " . $fileDir . " doesn`t exists.");
               return;
           }
           require($fileDir);
       }
    }
}
