<?php

namespace IZON\MVC\Exceptions\Handlers;

use Exception;
use Psr\Log\LogLevel;
use IZON\MVC\Controllers\SimpleErrorController;
use \IZON\MVC\Exceptions\PageNotFoundException;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\ModelAndView;
use Throwable;

/**
 * Handles if page is not found
 */
class ClientErrorExceptionHandler implements IAppExceptionHandler {

    /**
     * @var string<class-string>
     */
    protected string $exceptionClass;

    protected SimpleErrorController $controller;

    /**
     * @var Interceptor[]
     */
    protected array $interceptors = [];

    /**
     * @param SimpleErrorController $controller
     * @param string<class-string> $exceptionClass
     */
    public function __construct(
        string $exceptionClass,
        SimpleErrorController $controller
    ) {
        $this->controller = $controller;
        $this->exceptionClass = $exceptionClass;
    }

    /**
     * @param Interceptor[] $interceptors
     */
    public function setInterceptors(array $interceptors): void {
        $this->interceptors = $interceptors;
    }


    public function getLogLevel(): string {
        return LogLevel::WARNING;
    }

    /***
     * @param PageNotFoundException $exception
     * @param null|HttpRequest $request
     * @throws Exception
     * @return ModelAndView|NULL
     */
    public function handleException(Throwable $exception, ?HttpRequest $request): ?ModelAndView {
        if(empty($request)) {
            throw new Exception(self::class . ' is not able to handle exception without HttpRequest object');
        }

        foreach ($this->interceptors as $interceptor) {
            $preHandleResult = $interceptor->preHandle($request);
            if ($preHandleResult instanceof PreHandleResult) {
                if($preHandleResult->isExternalRedirect() || $preHandleResult->isInternalRedirect()) {

                }
            }
        }

        $modelAndView = $this->controller->execute($request);

        foreach ($this->interceptors as $interceptor) {
            $interceptor->postHandle($request, $modelAndView);
        }

        foreach($this->interceptors as $interceptor) {
            $interceptor->afterCompletion($request, null);
        }

        return $modelAndView;
    }

    public function isFor(Throwable $exception): bool {
        return is_a($exception, $this->exceptionClass)
            || is_subclass_of($exception, $this->exceptionClass);
    }
}
