<?php

namespace IZON\MVC\RPC\JsonRPC;

use \JsonSerializable;

/**
 * Normalni odpover JsonRPC
 */
class ErrorResponse implements JsonSerializable {
    
    protected $jsonrpc = "2.0";
    
    protected $errorCode; 
    
    protected $errorMessage;
    
    protected $id;
    
    function __construct($errorCode, $errorMessage, $id) {
        $this->errorCode = $errorCode;
        $this->errorMessage = $errorMessage;
        $this->id = $id;
    }

    function getJsonrpc() {
        return $this->jsonrpc;
    }

    function getErrorCode() {
        return $this->errorCode;
    }

    function getErrorMessage() {
        return $this->errorMessage;
    }
    
    function getId() {
        return $this->id;
    }

    public function jsonSerialize() {
        return [
            'jsonrpc' => $this->jsonrpc,
            'error' => ["code" => $this->errorCode, "message" => $this->errorMessage],
            'id' => $this->id,
        ];
    }
}
