<?php

namespace IZON\MVC\Routers;

use PDO;

use IZON\Utils\Locale;

use IZON\Logs\Logger;
use IZON\DB\DBConnection;

use IZON\MVC\HttpRequest;
use IZON\MVC\PageInfo;

use IZON\MVC\Interceptors\PageInfoInterceptor;

/**
 * Definice routovani nacitana z db
 * @deprecated use DBRouteDefinition2 instead
 */
class DBRouteDefinition implements RouteDefinition {
    
    /**
     * 
     * @var DBConnection
     */
    protected $dbConnection;
    
    /**
     * interceptory pridavane pred vsechny controllery teto oute definition
     * @var array 
     */
    protected $interceptors = [];

    /**
     * interceptory vazane na jednotlive controllery
     * pole poli, klic je uid controlleru 
     * a hodnota je pole s id jednotlivych controlleru
     * @var array 
     */
    protected $controllerInterceptors = [];

    /**
     *
     * @var Logger 
     */
    protected $log = NULL;
    
    
    public function __construct($dbConnection, $controllerInterceptors = []) {
        $this->dbConnection = $dbConnection;
        $this->controllerInterceptors = $controllerInterceptors;
        
        // pridava PageInfoInterceptor ktery nacit informace o prave zobrazovane strance
        $this->interceptors[] = new PageInfoInterceptor();
        
        $this->log = Logger::getLogger(self::class);
    }
    
    public function findRoute(HttpRequest $request) {
        /** @var PDO $conn */
        $conn = $this->dbConnection->getPDO();
        
        // TODO: mohlo by se prekladat na 
        $sql = 'SELECT * FROM structure_cz WHERE enabled = 1';
        foreach ($conn->query($sql) as $row) {
            $urlPattern = $row['url'];
            
            $this->log->info("Trying pattern ". $urlPattern);
//            echo $urlPattern ." ". $request->getUrl();
            $matches = [];
//            preg_match('/(?P<word>t[^s]+)/',$test,$matches);
            if( preg_match('#'. $urlPattern .'#', $request->getUrl(), $matches) ) {  // reqexp musi byt obalen delimiterem
                $parameters = $matches;
                unset($parameters[0]);
                
                // prekopirovat parametry z adresy do $request
                foreach($parameters as $key => $value) {
                    $request->addParameter($key, $value);
                }
                
                // nastavi pageinfo do HttpRequest, aby bylo pristupne pro controller 
                $pageInfo = $this->createPageInfo($conn, $row, $request->getURL());
                $request->addParameter(PageInfo::PAGE_INFO_INDENTIFIER, $pageInfo);
                
                $routeInfo = new RouteInfo();
                $routeInfo->setUrl($request->getUrl());
                $routeInfo->setPattern($urlPattern);
                $routeInfo->setContrlollerId($row['controller_uid']);
                $routeInfo->setParameters($parameters);

                $interceptors = $this->interceptors;
                if( isset($this->controllerInterceptors[$row['controller_uid']]) ) {
                    $interceptors = array_merge($interceptors, $this->controllerInterceptors[$row['controller_uid']]);
                }
                
                $routeInfo->setInterceptors($interceptors);
                
                // nastavuje id volaneho controlleru
                $request->setCalledControllerId($row['controller_uid']);
                
                return $routeInfo;
            }
        }
        return NULL;
    }

    public function findURL($controllerId, array $parameters, $methodName, Locale $locale) {
        $this->log->info("searching for url for controolerId = $controllerId with ". count($parameters) ." parameters");
        
        /** @var PDO $conn */
        $conn = $this->dbConnection->getPDO();
        
        $sql = 'SELECT * FROM structure_cz where controller_uid = :controllerId';
        $statement = $conn->prepare($sql);
        $statement->bindParam(':controllerId', $controllerId);
        $statement->execute();
        
        // projde vsechny controllery s danym $controllerId
        while( $row = $statement->fetch(PDO::FETCH_ASSOC) ) {
            $outputURL = $row["output_url"]; // testovane url
            
            // parametry, ktere se maji pripojit za ? do adresy
            $appendParams = $parameters;
            
            // proved prvni match
            $matched = preg_match("#\(([a-zA-Z0-9]+)\)#", $outputURL, $matches);
            if( $matched != false ) { // a navratove url obsahuje nejaky parametr
                // nalezen prvni match, zkontrolovat jestli v $parameters je dany parametr a nahradit ho
                $dontHaveMatch = false; // priznak jestli nebyl nalezen match
                do {
                    $patamName = $matches[1];
                    if( !isset($parameters[$patamName]) ) { // $parameters neobsahuje takovou polozku, zkusit dalsi match
                        $dontHaveMatch = true;
                        break;
                    }
                    // nahradit match parametrem
                    $outputURL = str_replace("($patamName)", $parameters[$patamName], $outputURL);
                    unset($appendParams[$patamName]);
                    
                } while( preg_match("#\(([a-zA-Z0-9]+)\)#", $outputURL, $matches) );
                if( $dontHaveMatch ) { // jit na dalsi pravidlo
                    continue;
                }
            }
            
            $appendArray = [];
            foreach($appendParams as $index => $value) {
                $appendArray[] = $index ."=". $value;
            }
            
            if( !\IZON\Arrays\isEmpty($appendArray) ) {
                $outputURL .= "?". implode($appendArray, '&');
            }
            return $outputURL;
            
        }
        
        return NULL;
        
//        foreach ( as $row) {
//            $urlPattern = $row['url'];
////            echo $urlPattern ." ". $request->getUrl();
//            $matches = [];
////            preg_match('/(?P<word>t[^s]+)/',$test,$matches);
//            if( preg_match('#'. $urlPattern .'#', $request->getUrl(), $matches) ) {  // reqexp musi byt obalen delimiterem
//                $parameters = $matches;
//                unset($parameters[0]);
//                
//                $routeInfo = new RouteInfo();
//                $routeInfo->setUrl($request->getUrl());
//                $routeInfo->setPattern($urlPattern);
//                $routeInfo->setContrlollerId($row['controller_uid']);
//                $routeInfo->setParameters($parameters);
//                
//                return $routeInfo;
//            }
//        }
//        return NULL;
    }

    /**
     * @param PDO $conn db connection
     * @param array $row row from structure_xx
     * @return PageInfo informace o strance ziskane z db
     */
    protected function createPageInfo(PDO $conn, array $row, $url) {
        $pageInfo = new PageInfo();
        $pageInfo->setControllerId($row["controller_uid"]);
        $pageInfo->setTitle($row["title"]);
        $pageInfo->setShortTitle($row["short_title"]);
        $pageInfo->setDesctiprion($row["description"]);
        $pageInfo->setKeywords($row["keywords"]);
        $pageInfo->setRobots($row["robots"]);
        $pageInfo->setURL($url);
        
        // prochazi predky ke korenu
        $breadcrumbs = [];
        
        $parentId = $row["parent_id"];
        $sql = 'SELECT * FROM structure_cz where id = :parentId';
        $statement = $conn->prepare($sql);
        $statement->bindParam(':parentId', $parentId);
        $statement->execute();
        
        // FIXME: musi prochazet i do hloubky aby se dostal az ke korenu
        while( $bcRow = $statement->fetch(PDO::FETCH_ASSOC) ) {
            $bcPageInfo = new PageInfo();
            $bcPageInfo->setControllerId($bcRow["controller_uid"]);
            $bcPageInfo->setTitle($bcRow["title"]);
            $bcPageInfo->setShortTitle($bcRow["short_title"]);
            $bcPageInfo->setDesctiprion($bcRow["description"]);
            $bcPageInfo->setKeywords($bcRow["keywords"]);
            $bcPageInfo->setRobots($bcRow["robots"]);
            
            $breadcrumbs[] = $bcPageInfo;
            
            $parentId = $bcRow["parent_id"];
            $statement->closeCursor(); // uvolnit cursot
            $statement->bindParam(':parentId', $parentId);
            $statement->execute();
        }
        
        $breadcrumbs = array_reverse($breadcrumbs);
        $pageInfo->setBreadcrumbs($breadcrumbs);
        
        return $pageInfo;
    }
    
    /**
     * nastavuje interceptory platne pro vsechny controllery z teto route definition
     * @param array $interceptors
     */
    function setInterceptors(array $interceptors) {
        $this->interceptors = $interceptors;
        // pridava PageInfoInterceptor ktery nacit informace o prave zobrazovane strance
        $this->interceptors[] = new PageInfoInterceptor();
    }
    
    /**
     * nastavuje interceptory jen pro specificke controllery
     * @param array $interceptors pole poli kde klicem je identifier controlleru a hodnota je pole interceptoru, ktere se na nem maji provezt
     */
    function setControllerInterceptors(array $interceptors) {
        $this->controllerInterceptors = $interceptors;
    }
}
