<?php

namespace IZON\MVC;

/**
 * Obsauje informace o strance jako kratky titulek, titulek, popis atd.
 */
class PageInfo {
    
    const PAGE_INFO_INDENTIFIER = '_pageInfo';
    
    /**
     * url prave zobrazovane stranky
     * @var string 
     */
    protected $url;


    /**
     * which controller serves this page
     * @var string 
     */
    protected $controllerId;


    /**
     * titulek stranky, ktery se ma pouzit v title tgagu v hlavicce
     * @var string 
     */
    protected $title;
    
    /**
     * kratky nazev, ktery se ma pouzit treba ve drobeccich
     * @var string 
     */
    protected $shortTitle;

    /**
     * kratky popis stranky, ktery se dapouzit v description tagu
     * @var string 
     */
    protected $description;
    
    /**
     * obsahuje klicova slova pouzivana v keywords tagu v hlavicce
     * @var string 
     */
    protected $keywords;
    
    /**
     * obsah hlavickoveho tagu robots
     * @var string 
     */
    protected $robots;
    
    /**
     * @var array pole pripadnych parametru pro volani teto stranky pokud je zname pri resolvovani url na controller
     */
    protected $parameters = [];
    
    /**
     * @var string name of controller method, that was called
     */
    protected $methodName = NULL;


    /**
     * drobecky ke koreni webu
     * TODO: co v nem ma presne byt
     * Obsahuje pageinfo od predku
     * @var array 
     */
    protected $breadcrumbs = [];
    
    
    /**
     * 
     * @param string $controllerId
     * @return boolean returns true has parent a.i. first predecessot on part to root page
     */
    function hasParent($controllerId) {
        if( isset($this->breadcrumbs[count($this->breadcrumbs)-1]) ) { // ma alespon jednoho predka
            $pageInfo = $this->breadcrumbs[count($this->breadcrumbs)-1];
            if( $pageInfo->getControllerId() == $controllerId ) {
                return true;
            }
        }
        return false;
    }
    
    /**
     * 
     * @param string $controllerId
     * @return boolean returns true if has predecessor
     */
    function hasPredecessor($controllerId) {
        foreach($this->breadcrumbs as $pageInfo) {
            if( $pageInfo->getControllerId() == $controllerId ) {
                return true;
            }
        }
        return false;
    }
    
    
    /**
     * @deprecated
     */
    function getDesctiprion() {
        return $this->getDescription();
    }
    
    /**
     * @deprecated
     */
    function setDesctiprion($description) {
      $this->setDescription($description);
    }
    
    
/// geneovane gettery a settery
    function getURL() {
        return $this->url;
    }

    function getControllerId() {
        return $this->controllerId;
    }

    function getTitle() {
        return $this->title;
    }

    function getShortTitle() {
        return $this->shortTitle;
    }

    function getDescription() {
      return $this->description;
    }

    function getKeywords() {
        return $this->keywords;
    }

    function getRobots() {
        return $this->robots;
    }

    function getParameters() {
        return $this->parameters;
    }

    function getBreadcrumbs() {
        return $this->breadcrumbs;
    }

    function setURL($url) {
        $this->url = $url;
    }

    function setControllerId($controllerId) {
        $this->controllerId = $controllerId;
    }

    function setTitle($title) {
        $this->title = $title;
    }

    function setShortTitle($shortTitle) {
        $this->shortTitle = $shortTitle;
    }
    
    function setDescription($description) {
        $this->description = $description;
    }

    function setKeywords($keywords) {
        $this->keywords = $keywords;
    }

    function setRobots($robots) {
        $this->robots = $robots;
    }

    function setParameters($parameters) {
        $this->parameters = $parameters;
    }

    function setBreadcrumbs($breadcrumbs) {
        $this->breadcrumbs = $breadcrumbs;
    }
    
    function getMethodName() {
        return $this->methodName;
    }

    function setMethodName($methodName) {
        $this->methodName = $methodName;
    }
}
