<?php

namespace IZON\MVC\Locale;

use \IZON\Utils\Locale;

/**
 *  Locale resolver that takes locale from start of url
 */
class URLLocaleResolver implements LocaleResolver {
    
    /**
     *
     * @var string defaultni locale, ktere se ma pouzit pokud neni zjisteno jine 
     */
    protected $defaultLanguage;
    
    /**
     *
     * @var array podporovane locale pro stranku, pokud nalezeno jine nez podporovane preklopi se defaultni 
     */
    protected $supportedLocales;

    /**
     *
     * @var string v jakem adresari se pocale nachazeji 
     */
    protected $localeDir;

    /**
     *
     * @var string 
     */
    protected $tmpDir;
    
    /**
     *
     * @var boolean 
     */
    protected $develServer;
    
    /**
     *
     * @var string 
     */
    protected $serverSystem;
            
    function __construct($defaultLanguage, $supportedLocales, $localeDir, $develServer = false, $serverSystem = '') {
        
        $this->defaultLanguage = $defaultLanguage;
        $this->supportedLocales = $supportedLocales;
        
        if( is_dir($localeDir) ) {
            $this->localeDir = $localeDir;
        } else {
            // FIXME: ve verzi co rozbili spetnou kompatibilitu tuto vetev odstranit
            $this->localeDir = __BASE_DIR__ ."/". $localeDir;
        }
        // FIXME: ve verzi co rozbili spetnou kompatibilitu predavat pres konstruktor
        $this->tmpDir = __BASE_DIR__ ."/tmp";
        $this->develServer = $develServer;
        $this->serverSystem = $serverSystem;
    }
    
    /**
     * 
     * @param string $requestURL
     * @param array $requestParams
     * @return \Locale
     */
    public function resolveLocale($requestURL, $requestParams) {
        $lang   = $this->defaultLanguage;
        $domain = $this->defaultLanguage;
        $selectedLocale = str_replace('-', '_', $this->supportedLocales[$domain]);
        foreach( $this->supportedLocales as $key => $locale) {
            if( $key != $this->defaultLanguage // neni defaultni locale
                && (\IZON\String\startsWith($requestURL, "/$key/")
                    || $requestURL == "/$key" ) ) {
                $lang   = $key;
                $domain = $key;
                $selectedLocale = str_replace('-', '_', $locale);
                break;
            }
        }
        $locale     = $selectedLocale;
        $newDomain  = $domain;
        
        putenv("LANG=$lang");
        putenv("LC_ALL=$selectedLocale");
        // tries to set exactlly $selectedLocale locale, if not found on os select one of 'cs_CZ', 'cs', 'en_US', 'en'
        $fallbackLocale = setlocale(LC_ALL, $selectedLocale, 'cs_CZ', 'cs', 'en_US', 'en');
        // set formating for numbers to english NEEDS TO BE TESTED
//        setlocale(LC_NUMERIC, 'en_US');
        
        $filename = $this->localeDir .'/'. $locale ."/LC_MESSAGES/$domain.mo";

        if( file_exists($filename) ) {
            
            $mtime = filemtime($filename);
            $newLocaleDir = $this->tmpDir .'/locale/'. $locale .'/LC_MESSAGES';
            // hack for local devel win10 server
            if($this->develServer && $this->serverSystem == 'win10') { // is devel mode and windows 10 os
                $newLocaleDir = $this->tmpDir .'/locale/'. $fallbackLocale .'/LC_MESSAGES';
                // win 10 needs to have domain name starting with messages_
                $newDomain = 'messages_'. $domain;
            } 
            
            $filename_new = $newLocaleDir .'/'.$newDomain.'_'.$mtime.'.mo';
            
            if( !is_dir($newLocaleDir) ) {
                mkdir($newLocaleDir, 0777, true);
            }
            if(!file_exists($filename_new)) {
                copy($filename, $filename_new);
                chmod($filename_new, 0777);
            }
            $domain_new = "{$newDomain}_{$mtime}";
            bindtextdomain($domain_new, $this->tmpDir ."/locale");
            textdomain($domain_new);
            bind_textdomain_codeset($domain_new, 'UTF-8');
        }
        
        return Locale::forLocaleTag(str_replace('_', '-', $selectedLocale));
        
    }
    /**
     * 
     * @param string $requestURL
     * @param Locale $locale
     */
    public function modifyRequestURL($requestURL, Locale $locale) {
        // odstran language z url
        
        if( $locale->getLanguage() == 'cs' ) {
            if( $requestURL == "/cz"
                ||  \IZON\String\startsWith($requestURL, "/cz/") ) {
                $ret = str_replace("/cz", "", $requestURL);
                if( $ret == '' ) {
                    $ret = '/';
                }
                return $ret;
            } else {
                return $requestURL;
            }
        }
        // DOTO-devel: brát locale part z configu ne podle language
        if( $requestURL == "/". $locale->getLanguage() 
            || \IZON\String\startsWith($requestURL, "/". $locale->getLanguage() ."/") ) { // uriznout jen pokud je samotne nebo zacina a ma dalsi cast
            $ret = mb_substr($requestURL, mb_strlen("/". $locale->getLanguage()));
            if( $ret == '' ) {
                $ret = '/';
            }
            return $ret;
        } else {
            return $requestURL;
        }
    }
    
    /**
     * 
     * @param string $requestURL
     * @param Locale $locale
     * @return string url s pridanymi informcemi o locale
     */
    public function modifyOutpultURL($requestURL, Locale $locale) {
//        var_dump($locale->getLanguage());
        if( $locale->getLanguage() == 'cs' ) { // preloz cs_CZ na cz_CZ
            if( $this->defaultLanguage != 'cz' ) {
                $requestURL = "/". 'cz' . $requestURL;
            }
        } else {
            if( $this->defaultLanguage != $locale->getLanguage() ) {
                $requestURL = "/". $locale->getLanguage() . $requestURL;
            }
        }
        return $requestURL;
    }
}