<?php

namespace IZON\MVC\Exceptions\Handlers;

use \IZON\Logs\LogLevel;
use IZON\MVC\Exceptions\AccessForbiddenException;
/**
 * Handles if page is not found
 */
class AccessForbiddenExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow = "www/errors/403.php";

    /**
     * PageNotFoundExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to PageNotFound Page (file)
     */
    public function __construct($htmlToShow = "www/errors/403.php") {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::INFO;
    }

    public function handleException($exception) {
        header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden');
        require __BASE_DIR__. '/'. $this->htmlToShow;
    }

    public function isFor($exception) {
        return $exception instanceof AccessForbiddenException;
    }
}
