<?php

namespace IZON\MVC\Tests;

use PHPUnit\Framework\TestCase;

use IZON\DB\DBConnection;
use IZON\MVC\Routers\AjaxRouteDefinition;

/**
 * @covers AjaxRouteDefinition
 */
class AjaxRouteDefinitionTest extends TestCase {
    
    /**
     * @var AjaxRouteDefinition 
     */
    protected $routeDefinition;

            
    public function setUp() {
        $this->routeDefinition = new AjaxRouteDefinition();
    }
    
    public function testAddControlerInterceptors() {
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller2", ["interceptor1", "interceptor2"]);
    }
    
    public function testAddDupliciteControlerInterceptors() {
        $this->expectException(\Exception::class);
        
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        $this->routeDefinition->addControllerInterceptors("controller1", ["interceptor1", "interceptor2"]);
        
    }
}
