<?php

namespace IZON\MVC\RPC\JsonRPC;

use \Exception;

use IZON\Utils\Locale;

use \IZON\Logs\Logger;

use \IZON\DI\Container;

use IZON\MVC\Routers\RouteInfo;
use IZON\MVC\Routers\RouteDefinition;

use \IZON\MVC\RPC\JsonRPC\JsonRPCController;
use \IZON\MVC\RPCAccessControl;

use IZON\MVC\HttpRequest;

/**
 * Definice routovani pro json rpc
 * TODO: prejit na route definition a controller,
 * potrebuju nejak predat do controlleru service co se ma volat, 
 * asi bude nejlepsi pridat do JsonRPCRouteDefinition container
 */
class JsonRPCRouteDefinition implements RouteDefinition {
    
    /**
     * class of controller to call
     * @var type 
     */
    protected $controllerClass = JsonRPCController::class;


    /**
     * prefix pro routovani admina
     * @var type 
     */
    protected $jsonRPCRoutePattern = "^/_jsonrpc/([/a-zA-Z0-9\.]+).jsonrpc";

    /**
     *
     * @var Container 
     */
    protected $container = NULL;


    /**
     *
     * @var Logger 
     */
    protected $log = NULL;
    
    /**
     * @var Container
     */
    public function __construct($container) {
        $this->container = $container;
        
        // sprovoznit logovani
        $this->log = Logger::getLogger(self::class);
    }
    
    public function findRoute(HttpRequest $request) {
//        $this->log->info("calling method findRoute: url = ". $request->getUrl());
        
        if( !preg_match('#'. $this->jsonRPCRoutePattern .'#', 
                $request->getUrl(), 
                $matches) ) {  // not json rpc request
            return null;
        }
        
        // TODO: dont use $_SERVER superglobal
        if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
            $request_json = file_get_contents( 'php://input' );
            $servceId = $_REQUEST["serviceId"];
            $json = json_decode($request_json);

            $method = $json->method;
            $parameters = $json->params;
            $id = $json->id;
        } else if( $_SERVER['REQUEST_METHOD'] == 'GET') {
            $servceId = $_REQUEST["serviceId"];
            $method = $_REQUEST["method"];
            $parameters = json_decode( urldecode($_REQUEST["params"]) );
            $id = intval($_REQUEST["id"]);
        } else {
            throw new Exception("Unsupportrd method ". $_SERVER['REQUEST_METHOD']);
        }
        
        if( !$this->container->has($servceId) ) {
            throw new Exception("Call of undefined service $servceId");
        }
        
        // FIXME: nejak lepe zpravovavat parametry nejlepe asi presunout do JsonRPCController at se nemusi JsonRPCRouteDefinition predavat container
        $reflectionClass = new \ReflectionClass( $this->container->get($servceId) );
        $this->log->info("Creating reflection class.");

        $reflectionMethod = $reflectionClass->getMethod($method);
        
        if( is_object($parameters) ) { // jsou pojmenovane paremetry
            $this->log->info("Parameters are object. .");

           // vyfiltruje jen parametry, ktere metoda ma
           // TODO: rozhonout, jestli vyhlasovat chybu pokud je nejaka nesrovnalost 
           // TODO: provadet kontrolu a revod typu
           $passParams = [];
           foreach( $reflectionMethod->getParameters() as $reflectionParam ) {
               /* @var $reflectionParam ReflectionParameter */
               $name = $reflectionParam->getName();
               var_dump($reflectionParam);
               if( isset($parameters->$name) ) {
                   $passParams[] = $parameters[$reflectionParam->$name];
               } else {
                   $passParams[] = $reflectionParam->getDefaultValue();
               }
           }
       } else if(is_array($parameters)) { // je normalni pole
           $passParams = [];
           $index = 0;
           foreach( $reflectionMethod->getParameters() as $reflectionParam ) {
               /* @var $param ReflectionParameter */
               if (isset($parameters[$index])) {
                   $passParams[] = $parameters[$index];
               } else {
                   $passParams[] = $reflectionParam->getDefaultValue();
               }
               $index++;
           }
       } else {

       }
        
        $request->addParameter("_PARAMS", $passParams);
        $request->addParameter("_SERVICE_ID", $request->getParameter("serviceId"));
        $request->addParameter("_METHOD", $method);
        $request->addParameter("_REQUEST_ID", $id);
        
        $routeInfo = new RouteInfo();
        $routeInfo->setUrl($request->getUrl());
        $routeInfo->setPattern($this->jsonRPCRoutePattern);
        $routeInfo->setContrlollerId($this->controllerClass);
//        $routeInfo->setMethodName($method);
        $routeInfo->setParameters($parameters);
        
        $this->log->info("prepared router <pre>". $routeInfo ."</pre>");
        
        return $routeInfo;
    }

    public function findURL($controllerId, array $parameters, $methodName, Locale $locale) {
       // FIXME: vymyslet jak spetne routovat na nejaky service
    }

}
