<?php

namespace IZON\MVC\Exceptions\Handlers;

use \IZON\Logs\LogLevel;
use \IZON\MVC\Exceptions\InternalServerErrorException;

/**
 * Handles if page is not found
 */
class InternalServerErrorExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow = "www/errors/500.php";

    /**
     * InternalServerErrorExceptionHandler constructor.
     * @param string $htmlToShow - string absolute path (form htdocs) to InternalServerError Page (file)
     */
    public function __construct($htmlToShow = "www/errors/500.php") {
        $this->htmlToShow = $htmlToShow;
    }


    public function getLogLevel() {
        return LogLevel::ERROR;
    }

    public function handleException($exception) {
        header($_SERVER['SERVER_PROTOCOL'].' 500 Internal Server Error');
        require __BASE_DIR__. '/'. $this->htmlToShow;
    }

    public function isFor($exception) {
        return $exception instanceof \Exception;
    }
}
