<?php

namespace IZON\MessageBus\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

use IZON\MessageBus\Impl\SimpleMessageBus;

/**
 * provede zpracovani zprav registrovanych v SimpleMessageBus v after completion metode
 */
class HandleSimpleMessageBusMessagesInterceptor implements Interceptor {
    
    /**
     * @var SimpleMessageBus
     */
    protected $simpleMessageBus;

    
    function __construct(SimpleMessageBus $simpleMessageBus, array $messageConsumersToRegister) {
        $this->simpleMessageBus = $simpleMessageBus;
        foreach ($messageConsumersToRegister as $consumer) {
            $this->simpleMessageBus->simpleRegisterConsumer($consumer);
        }
    }

    
    public function afterCompletion(HttpRequest $request, $exception) {
        $this->simpleMessageBus->handleRegistredMessages();
    }

    public function postHandle(HttpRequest $request, ModelAndView $mav) {
        
    }

    public function preHandle(HttpRequest $request) {
        
    }
}
