<?php

namespace IZON\MessageBus;

use IZON\MessageBus\MessageBus;
use IZON\MessageBus\MessageConsumer;

/**
 * reprezentuje registraci consumeru na sbernici, obsahuje informace na jakou sbernici se
 * consumer registtroval a umoznuje se z ni odhlasit
 */
class MessageConsumerRegistration {
    
    /**
     * @var MessageBus
     */
    protected $messageBus;

    /**
     * @var MessageConsumer consumer, ktery ma zpracovat zpravu
     */
    protected $messageConsumer;
    
/// geneovany konstruktor  
    function __construct(MessageBus $messageBus, MessageConsumer $messageConsumer) {
        $this->messageBus = $messageBus;
        $this->messageConsumer = $messageConsumer;
    }
    
    
/// generovane gettery a settery
    function getMessageBus() {
        return $this->messageBus;
    }    
    
    function getMessageConsumer() {
        return $this->messageConsumer;
    }
}
