<?php

namespace IZON\MessageBus;

use IZON\MessageBus\Message;
use IZON\MessageBus\MessageConsumer;

/**
 * sbernice zprav pro poslilani zprav consumerum, kteri je zpravovavaji
 * 
 * inspirace https://www.rabbitmq.com
 */
interface MessageBus {
    
    /**
     * registruje consumer, ktery zpracovava zpravy zpravy se sbernice
     * @param MessageConsumer $consumer
     * @return MessageConsumerRegistration registrace na sbernici
     */
    public function simpleRegisterConsumer(MessageConsumer $consumer);
    
    /**
     * publikuje zpravu na sbernici do defaultni fromty
     * @param Message $message
     */
    public function simplePublish(Message $message);
}
