<?php

namespace IZON\Mailer\Impl;

use \IZON\Logs\Logger;

use PHPMailer\PHPMailer\PHPMailer;

use \IZON\Mailer\Mailer;
use \IZON\Mailer\Mail;


use \IZON\Mailer\Exceptions\MailException;

/**
 * Iplementace maileru posilajici pres smtp
 */
class PHPMailFunctionMailer implements Mailer {
    /**
     * 
     * @var Logger 
     */
    protected $log;

    public function __construct() {
        // sprovoznit logovani
        $this->log = Logger::getLogger(self::class);
    }
    
    public function sendMail(Mail $mail) {
        $this->log->info("Creating PHPMailer");
        
        $phpMailer = new PHPMailer(true);
        
        //Set who the message is to be sent from
        if( $mail->getFrom()['name'] != NULL ) {
            $phpMailer->setFrom($mail->getFrom()['email'], $mail->getFrom()['name']);
        } else {
            $phpMailer->setFrom($mail->getFrom()['email']);
        }
        $this->log->info("Setting from");
        
        // nastaveni kam se ma email odeslat
        foreach( $mail->getTo() as $to) {
            //Set who the message is to be sent to
            if( $to['name'] == NULL ) {
                $phpMailer->addAddress($to['email']);
            } else {
                $phpMailer->addAddress($to['email'], $to['name']);
            }
        }
        $this->log->info("Setting to");
        
        // nastaveni kam se ma email odeslat
        foreach( $mail->getReplyTo() as $to) {
            //Set who the message is to be sent to
            if( $to['name'] == NULL ) {
                $phpMailer->addReplyTo($to['email']);
            } else {
                $phpMailer->addReplyTo($to['email'], $to['name']);
            }
        }
        $this->log->info("Setting reply to");
        
        // Set the subject line
        $phpMailer->Subject = $mail->getSubject();
        // jestli se jedna o html email
        $phpMailer->isHTML($mail->isHtml());
        // nastavuje telo textu
        $phpMailer->Body = $mail->getBody();
        // nastavuje alternativni text
        if( $mail->getAltBody() != '') {
            $phpMailer->AltBody = $mail->getAltBody();
        }
        
        // prida vsechny prilohy
        foreach($mail->getAttachments() as $attachement) {
            $phpMailer->addAttachment($attachement["path"], $attachement["name"], $attachement["encoding"], $attachement["type"]);
        }
        
        // TODO: nastavit codepage atd
        // Codepage UTF8
        $phpMailer->CharSet  = 'utf-8';
        
        try {
            //send the message, check for errors
            if (!$phpMailer->send()) {
                $e = new MailException($phpMailer->ErrorInfo);
                $this->log->warning("Send email exception.", ["exception" => $e]);
                throw $e;
            }
        } catch(\PHPMailer\PHPMailer\Exception $e) {
            $e = new MailException($e);
            $this->log->warning("Send email exception.", ["exception" => $e]);
            throw $e;
        }
    }
}
