<?php

namespace IZON\Mailer\Impl;

use \IZON\Logs\Logger;

use \IZON\Mailer\Mailer;
use \IZON\Mailer\Mail;

/**
 * mailer that uses user other mailer implementation and only changes $mail->getTo() to value defined in $develMailTo if $develModeOn
 */
class DevelMailer implements Mailer {
    
    /**
     * @var Mailer
     */
    protected $chainedMailer;

    /**
     * @var string[]
     */
    protected $develMailTo;

    /**
     * @var boolean
     */
    protected $develModeOn;


    /**
     * @var Logger
     */
    protected $logger;
    
    /**
     * 
     * @param Mailer $chainedMailer mailer to be used for sending email
     * @param string|string[] $develMailTo addresse or addresses to send email to 
     * @param bool $develModeOn if true send email to $develMailTo
     */
    public function __construct(Mailer $chainedMailer, $develMailTo, $develModeOn = false) {
        $this->chainedMailer = $chainedMailer;
        if( !is_array($develMailTo) ) {
            $this->develMailTo = [$develMailTo];
        } else {
            $this->develMailTo = $develMailTo;
        }
        $this->develModeOn = $develModeOn;
        
        // sprovoznit logovani
        $this->logger = Logger::getLogger(self::class);
    }
    
    public function sendMail(Mail $mail) {
        if( $this->develModeOn ) {
            $this->logger->info("Changing to emails from [". implode(', ', $mail->getTo()) ."] to ". $this->develMailTo);
            $mail->setTo($this->develMailTo);
        }
        $this->chainedMailer->sendMail($mail);
    }
}
