<?php

namespace IZON\Mailer;

use IZON\Mailer\Exceptions\MailException;
use IZON\Utils\Email;

/*
 * represents email to be sent
 */
class Mail {

    /**
     * @var string|null
     */
    protected $sender = NULL;

    /**
     * odesilatel emailu
     * pole ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     */
    protected $from = NULL;

    /**
     * pole poli obsahujici co se ma predvyplnit do prijemcu, kdyz se da odpovedet
     * ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     * @var array[]
     */
    protected $replyTo = [];

    /**
     * pole poli obsahujici prijemce
     * ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     * @var array []
     */
    protected $to = [];

    /**
     *
     * @var string
     */
    protected $subject;

    /**
     * jestli je email html
     * @var boolean
     */
    protected $html = false;

    /**
     * primarni telo zpravy
     * @var string
     */
    protected $body;

    /**
     * alternativni telo
     * @var string|null
     */
    protected $altBody = NULL;

    /**
     * @var array pripojene soubory
     */
    protected $attachments = [];

    /**
     * @var array pripojene embed soubory
     */
    protected $embeddedImages = [];

    function getFrom() {
        return $this->from;
    }

    /**
     *
     * @param string $email
     * @param string $name
     */
    function setFrom($email, $name = NULL) {
        if(!Email::isEmail($email)) {
            throw new MailException(sprintf('Not a valid email "%s"',$email));
        }
        $this->from = ['email' => $email, 'name' => $name];
    }

    function getReplyTo() {
        return $this->replyTo;
    }

    /**
     *
     * @param string $email
     * @param string $name
     */
    function addReplyTo($email, $name = NULL) {
        if(!Email::isEmail($email)) {
            throw new MailException(sprintf('Not a valid email "%s"',$email));
        }
        $this->replyTo[] = ['email' => $email, 'name' => $name];
    }

    function getTo() {
        return $this->to;
    }

    /**
     *
     * @param string $email
     * @param string $name
     */
    function addTo($email, $name = NULL) {
        if(!Email::isEmail($email)) {
            throw new MailException(sprintf('Not a valid email "%s"',$email));
        }
        $this->to[] = ['email' => $email, 'name' => $name];
    }

    /**
     * Set emails adresses where will be mail send
     *
     * Method set for every email address name = null
     * Emails will be set - not added
     *
     * @param array $emails Array of email addresses
     */
    function setTo(array $emails){
        $this->to = [];
        foreach($emails as $email){
            $this->addTo($email);
        }
    }

    function getSubject() {
        return $this->subject;
    }

    function getBody() {
        return $this->body;
    }

    function getAltBody() {
        return $this->altBody;
    }

    function setSubject($subject) {
        $this->subject = $subject;
    }

    function setBody($body) {
        $this->body = $body;
    }

    function setAltBody($altBody) {
        $this->altBody = $altBody;
    }

    function isHtml() {
        return $this->html;
    }

    function setHtml($html) {
        $this->html = $html;
    }

    function getAttachments() {
        return $this->attachments;
    }

    /**
     * pridava prilohu do mailu
     * @param string $path cesta k souboru
     * @param string $name nazev souboru
     * @param string $mimeType mime type souboru
     * @param string $encoding kodovani souboru
     */
    function addAttachment(
        $path,
        $name = '',
        $mimeType = 'application/octet-stream',
        $encoding = 'base64'
    ) {
        $this->attachments[] = [
            "path" => $path,
            "name" => $name,
            "encoding" => $encoding,
            "type" => $mimeType
        ];
    }

    public function getEmbeddedImages(): array {
        return $this->embeddedImages;
    }

    /**
     * pridava embed obrazek do mailu
     * @param string $path cesta souboru
     * @param string $cid cid souboru
     * @param string $name nazev souboru
     * @param string $mimeType mime type souboru
     * @param string $encoding kodovani souboru
     */
    function addEmbeddedImage(
        string $path,
        string $cid,
        string $name,
        string $mimeType = 'application/octet-stream',
        string $encoding = 'base64'
    ) {
        $this->embeddedImages[] = [
            "type" => 'file',
            "path" => $path,
            "cid" => $cid,
            "name" => $name,
            "encoding" => $encoding,
            "mimeType" => $mimeType
        ];

    }

    /**
     * pridava embed obrazek do mailu
     * @param string $content content of embed
     * @param string $cid cid souboru
     * @param string $name nazev souboru
     * @param string $mimeType mime type souboru
     * @param string $encoding kodovani souboru
     */
    function addStringEmbeddedImage(
        string $content,
        string $cid,
        string $name,
        string $mimeType = 'application/octet-stream',
        string $encoding = 'base64'
    ) {
        $this->embeddedImages[] = [
            "type" => 'content',
            "content" => $content,
            "cid" => $cid,
            "name" => $name,
            "encoding" => $encoding,
            "mimeType" => $mimeType
        ];

    }

    /// generated getters and setters
    function getSender()  {
        return $this->sender;
    }

    function setSender($sender) {
        $this->sender = $sender;
    }
}
