<?php

namespace IZON\Mailer\Impl;

use \IZON\Logs\Logger;

use IZON\Mailer\Exceptions\MailException;
use \IZON\Mailer\Mailer;
use \IZON\Mailer\Mail;

/**
 * mailer that switches chained mailers according to selde
 */
class SendersSwitcherMailer implements Mailer {
    
    /**
     * hash ['regex to represent senders' => new MailerToHandleSender(), ...]
     * @var Mailer[]
     */
    protected $chainedMailers = [];

    /**
     * @var Logger
     */
    protected $logger;
    
    /**
     * @param Mailer[] $chainedMailer ['regex to represent senders' => new MailerToHandleSender(), ...]
     */
    public function __construct(array $chainedMailers) {
        foreach($chainedMailers as $regex => $mailer) {
            if( @preg_match($regex, '') === FALSE ) {
                throw new MailException($regex .' is not valid regexp');
            }
            if( ! ($mailer instanceof Mailer) ) {
                throw new MailException($regex .' does not have valid Mailer implementation set');
            }
            $this->chainedMailers[$regex] = $mailer;
        }

        // init logger
        $this->logger = Logger::getLogger(self::class);
    }
    
    public function sendMail(Mail $mail) {
        $fromEmail = $mail->getFrom()['email'];
        foreach($this->chainedMailers as $regex => $mailer) {
            if( @preg_match($regex, $fromEmail) ) {
                $this->logger->info($fromEmail .' matches to '. $regex .' regex');
                $mailer->sendMail($mail);
                return;
            }
        }
        throw new MailException('From email '. $fromEmail .' does not have configured mailer.');
    }
}