<?php

namespace IZON\Mailer\Impl;

use \IZON\Logs\Logger;

use \IZON\Mailer\Mailer;
use \IZON\Mailer\Mail;

/**
 * mailer that uses user other mailer implementation and only changes $mail->getTo() to value defined in $develMailTo if $develModeOn
 */
class DevelMailer implements Mailer {
    
    /**
     * @var Mailer
     */
    protected $chainedMailer;

    /**
     * @var string 
     */
    protected $develMailTo;

    /**
     * @var boolean
     */
    protected $develModeOn;


    /**
     * @var Logger
     */
    protected $logger;
    
    
    public function __construct(Mailer $chainedMailer, $develMailTo, $develModeOn = false) {
        $this->chainedMailer = $chainedMailer;
        $this->develMailTo = $develMailTo;
        $this->develModeOn = $develModeOn;
        
        // sprovoznit logovani
        $this->logger = Logger::getLogger(self::class);
    }
    
    public function sendMail(Mail $mail) {
        if( $this->develModeOn ) {
            $this->logger->info("Changing to emails from [". print_r($mail->getTo(), true) ."] to ". $this->develMailTo);
            $mail->setTo([$this->develMailTo]);
        }
        $this->chainedMailer->sendMail($mail);
    }
}