<?php

namespace IZON\Mailer\Impl;

use IZON\Logs\Logger;
use IZON\Mailer\Mail;
use IZON\Mailer\Mailer;

/**
 * mailer that uses user other mailer implementation and only changes $mail->getTo() to value defined in $develMailTo if $develModeOn
 */
class DevelMailer implements Mailer {

    protected Mailer $chainedMailer;

    /**
     * @var string[]
     */
    protected $develMailsTo;

    /**
     * @var bool true if email should be sent to $develMailsTo instead of $mail->getTo()
     */
    protected $develModeOn;

    protected Logger $logger;

    /**
     *
     * @param Mailer $chainedMailer mailer to be used for sending email
     * @param string|string[] $develMailsTo address or addresses to send email to
     * @param bool $develModeOn if true send email to $develMailTo
     */
    public function __construct(Mailer $chainedMailer, $develMailsTo, $develModeOn = false) {
        $this->chainedMailer = $chainedMailer;
        if( !is_array($develMailsTo) ) {
            $this->develMailsTo = [$develMailsTo];
        } else {
            $this->develMailsTo = $develMailsTo;
        }
        $this->develModeOn = $develModeOn;

        // sprovoznit logovani
        $this->logger = Logger::getLogger(self::class);
    }

    public function sendMail(Mail $mail) {
        if( $this->develModeOn ) {
            $mailsTo = array_map(function($el) { return $el['email']; }, $mail->getTo());
            $this->logger->info(
                "Changing to emails from "
                ."[". implode(', ', $mailsTo) ."]"
                ." to [". implode(', ', $this->develMailsTo) ."]"
            );
            $mail->setTo($this->develMailsTo);
        }
        $this->chainedMailer->sendMail($mail);
    }
}
