<?php

namespace IZON\Mailer\Impl;

use \IZON\Logs\Logger;

use \IZON\Mailer\Mailer;
use \IZON\Mailer\Mail;

/**
 * mailer that uses user other mailer implementation and only changes $mail->getTo() to value defined in $develMailTo if $develModeOn
 */
class DevelMailer implements Mailer {

    /**
     * @var Mailer
     */
    protected $chainedMailer;

    /**
     * @var string[]
     */
    protected $develMailsTo;

    /**
     * @var boolean
     */
    protected $develModeOn;


    /**
     * @var Logger
     */
    protected $logger;

    /**
     *
     * @param Mailer $chainedMailer mailer to be used for sending email
     * @param string|string[] $develMailsTo addresse or addresses to send email to
     * @param bool $develModeOn if true send email to $develMailTo
     */
    public function __construct(Mailer $chainedMailer, $develMailsTo, $develModeOn = false) {
        $this->chainedMailer = $chainedMailer;
        if( !is_array($develMailsTo) ) {
            $this->develMailsTo = [$develMailsTo];
        } else {
            $this->develMailsTo = $develMailsTo;
        }
        $this->develModeOn = $develModeOn;

        // sprovoznit logovani
        $this->logger = Logger::getLogger(self::class);
    }

    public function sendMail(Mail $mail) {
        if( $this->develModeOn ) {
            $this->logger->info(
                "Changing to emails from "
                ."[". implode(', ', $mail->getTo()) ."]"
                ." to [". implode(', ', $this->develMailsTo) ."]"
            );
            $mail->setTo($this->develMailsTo);
        }
        $this->chainedMailer->sendMail($mail);
    }
}
