<?php

namespace IZON\Mailer;

/*
 * Reprezentuje mail, ktery ma byt zaslan
 */
class Mail {
    
    /**
     * odesilatel emailu
     * pole ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     */
    protected $from = NULL;
    
    /**
     * pole poli obsahujici co se ma predvyplnit do prijemcu, kdyz se da odpovedet
     * ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     * @var array[]
     */
    protected $replyTo = [];
    
    /**
     * pole poli obsahujici prijemce 
     * ['name' => 'Jmeno Co se ma zobrazit', 'email' => 'nekde@nekdo.cz']
     * @var array 
     */
    protected $to = [];
    
    /**
     * 
     * @var string 
     */
    protected $subject;
    
    /**
     * jestli je email html
     * @var boolean 
     */
    protected $html;

    /**
     * primarni telo zpravy
     * @var string
     */
    protected $body;
    
    /**
     * alternativni telo
     * @var string|null
     */
    protected $altBody = NULL;
    
    /**
     * @var array pripojene soubory 
     */
    protected $attachments = [];
    
    
    function getFrom() {
        return $this->from;
    }

    /**
     * 
     * @param string $email
     * @param string $name
     */
    function setFrom($email, $name = NULL) {
        $this->from = ['email' => $email, 'name' => $name];
    }
    
    function getReplyTo() {
        return $this->replyTo;
    }
    
    /**
     * 
     * @param string $email
     * @param string $name
     */
    function addReplyTo($email, $name = NULL) {
        $this->replyTo[] = ['email' => $email, 'name' => $name];
    }
    
    function getTo() {
        return $this->to;
    }

    /**
     * 
     * @param string $email
     * @param string $name
     */
    function addTo($email, $name = NULL) {
        $this->to[] = ['email' => $email, 'name' => $name];
    }

    /**
     * Set emails adresses where will be mail send
     *
     * Method set for every email address name = null
     * Emails will be set - not added
     *
     * @param array $emails Array of email addresses
     */
    function setTo(array $emails){
        $this->to = [];
        foreach($emails as $email){
            $this->to[] = ['email' => $email, 'name' => NULL];
        }
    }
    
    function getSubject() {
        return $this->subject;
    }

    function getBody() {
        return $this->body;
    }

    function getAltBody() {
        return $this->altBody;
    }

    function setSubject($subject) {
        $this->subject = $subject;
    }

    function setBody($body) {
        $this->body = $body;
    }

    function setAltBody($altBody) {
        $this->altBody = $altBody;
    }
    
    function isHtml() {
        return $this->html;
    }

    function setHtml($html) {
        $this->html = $html;
    }
    
    function getAttachments() {
        return $this->attachments;
    }
    
    /**
     * pridava prilohu do mailu
     * @param string $path cesta k souboru
     * @param string $name nazev souboru
     * @param string $type mime type souboru
     * @param string $encoding kodovani souboru
     */
    function addAttachment($path,
                            $name = '',
                            $type = 'application/octet-stream',
                            $encoding = 'base64') {
        $this->attachments[] = ["path" => $path,
                                "name" => $name,
                                "encoding" => $encoding,
                                "type" => $type];
    }
}
