<?php

namespace IZON\Mailer\Tests;

use PHPUnit\Framework\TestCase;

use IZON\Mailer\Impl\SMTPMailer;

/**
 * @covers SMTPMailer
 */
class SMTPMailerTest extends TestCase {
    
    protected $smtpServer = "mailer.izon.cz";
    
    protected $localhost = "www.izon.cz";

    protected $login = "cervenyknir@mailer.izon.cz";
    
    protected $password = "dAelisxQUQFZg";
    
    protected $dKIMParams = [
        'domain' => 'companygroup.cz', 
        'selector' => 'izon', 
        'private' => __BASE_DIR__ . '/private-data/DKIM/izon.pem', 
        'passphrase' => ''
    ];

    public function testMailerInstantiate() {
        $mailer = new SMTPMailer($this->smtpServer, $this->localhost);
        $mailer->setSmtpLoginAndPassword($this->login, $this->password);
    }
    
    public function testDkim() {
        $mailer = new SMTPMailer($this->smtpServer, $this->localhost);
        $mailer->setSmtpLoginAndPassword($this->login, $this->password);
        $mailer->setDKIMSettting($this->dKIMParams);
    }
}
