<?php

namespace IZON\MailQueue\Domain;

use Doctrine\ORM\Mapping as ORM;
use IZON\DB\DBObject;
use IZON\DBLocale\Repositories\LocaleRepository;
use IZON\IO\FileInterface;
use IZON\IO\RasterImageInterface;
use IZON\Utils\Date;
use IZON\IO\Image;
use IZON\IO\File;

/**
 * @author IZON s.r.o. <info@izon.cz>
 */
#[ORM\Entity(repositoryClass: LocaleRepository::class)]
#[ORM\Table(name: "core_mail_queue_attachments")]
class MailQueueAttachment {

    public const TYPE_ATTACHMENT = 'attachment';

    public const TYPE_EMBEDDED_IMAGE = 'embeddedImage';

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    #[ORM\ManyToOne(targetEntity: "MailQueue", inversedBy: "attachments")]
    #[ORM\JoinColumn(name: "fk_mail_queue_id", referencedColumnName: "id")]
    protected MailQueue $mailQueue;

    #[ORM\Column(type: 'file', options: ['webVisible' => false], nullable: false)]
    protected FileInterface $attachment;

    #[ORM\Column(nullable: false)]
    protected string $attachmentType;

    #[ORM\Column(nullable: true)]
    protected ?string $cid = null;

    #[ORM\Column(nullable: false)]
    protected string $name;

    #[ORM\Column(nullable: false)]
    protected string $encoding;

    #[ORM\Column(nullable: false)]
    protected string $mimeType;


    /**
     * @return int
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param ?int $id
     */
    public function setId(int $id): void {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getEncoding(): string {
        return $this->encoding;
    }

    /**
     * @param string $encoding
     */
    public function setEncoding(string $encoding): void {
        $this->encoding = $encoding;
    }

    /**
     * @return string
     */
    public function getAttachmentType(): string {
        return $this->attachmentType;
    }

    /**
     * @param string $attachementType
     */
    public function setAttachmentType(string $attachementType): void {
        $this->attachmentType = $attachementType;
    }

    /**
     * @return MailQueue
     */
    public function getMailQueue(): MailQueue {
        return $this->mailQueue;
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function setMailQueue(MailQueue $mailQueue): void {
        $this->mailQueue = $mailQueue;
    }

    /**
     * @return FileInterface
     */
    public function getAttachment(): FileInterface {
        return $this->attachment;
    }

    /**
     * @param FileInterface $attachment
     */
    public function setAttachment(FileInterface $attachment): void {
        $this->attachment = $attachment;
    }

    /**
     * @return string|null
     */
    public function getCid(): ?string {
        return $this->cid;
    }

    /**
     * @param string|null $cid
     */
    public function setCid(?string $cid): void {
        $this->cid = $cid;
    }

    /**
     * @return string
     */
    public function getMimeType(): string {
        return $this->mimeType;
    }

    /**
     * @param string $mimeType
     */
    public function setMimeType(string $mimeType): void {
        $this->mimeType = $mimeType;
    }
}
