<?php

namespace IZON\MailQueue\Repositories;


use Doctrine\ORM\Query;
use IZON\AppModules\IndividualPrices\Domain\IndividualPrice;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\DB\QueryParams\QueryParams;
use IZON\DB\Repository\BaseRepository;
use IZON\MailQueue\Domain\MailQueue;
use IZON\Utils\Date;


class MailQueueRepository extends BaseRepository {

    public function findOlderMailsThanInState(string $beforeDate, ?string $status = null) : Query {
        $mq = MailQueue::class;

        $statusWhere = "";
        if( $status !== null ) {
            $statusWhere = "AND mq.status = :$status";
        }

        $query = $this->getEntityManager()->createQuery("
            SELECT mq FROM $mq mq
            WHERE mq.date < :beforeDate
            ". $statusWhere ."
        ");
//        echo $query->getSQL(); die;
        return $query;
    }

    /**
     * @return Query
     */
    public function findNextFailedMailToSend(QueryParams $queryParams): Query {
        $mq = MailQueue::class;
        $dql = "
            SELECT mq FROM $mq mq
            ";
        $where = [];
        $where[] = "mq.status='".MailQueue::STATUS_FAIL."'";
        $where[] = "mq.date > :date";
        if($queryParams->hasParameter('excluded')) {
            $where[] = " mq.id NOT IN(:excluded) ";
        }
        $dql .= " WHERE ".implode(' AND ', $where);
        $dql .= " ORDER BY mq.id ASC";
        $query = $this->getEntityManager()->createQuery($dql);
        return $query;
    }

}
