<?php

namespace IZON\MailQueue\Services;

use IZON\DB\DBConnection;
use IZON\MailQueue\Domain\MailQueue;
use IZON\DB\EntityManagerInterface;
use IZON\MailQueue\Repositories\MailQueueRepository;
use IZON\Utils\Date;
use IZON\DB\QueryParams\OrderBy;

class MailQueueService {

    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @var MailQueueRepository
     */
    protected $mailQueueRepository;

    /**
     * BaseMailQueueService constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
        $this->mailQueueRepository = $entityManager->getRepository(MailQueue::class);
    }


    /**
     * @param $id
     * @return MailQueue
     */
    public function get($id) {
        $mailQueue = $this->mailQueueRepository->find($id);
        return $mailQueue;
    }

    /**
     * @return MailQueue[]
     */
    public function getAllNewInQueue(): iterable {
        $mailQueue = $this->mailQueueRepository->findBy(['status' => MailQueue::STATUS_NEW]);
        return $mailQueue;
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function save(MailQueue $mailQueue) {
        $mailQueue->setDate(new Date());
        $this->entityManager->persist($mailQueue);
        $this->entityManager->flush();
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function update(MailQueue $mailQueue) {
        $this->entityManager->persist($mailQueue);
        $this->entityManager->flush();
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function delete(MailQueue $mailQueue) {
        $this->entityManager->remove($mailQueue);
        $this->entityManager->flush();
    }

    /**
     * @param Date $date
     * @return MailQueue[]
     * @throws Exception
     */
    public function getOlderMailsThan(Date $date) {
        $mails = $this->mailQueueRepository->findOlderMailsThanInState($date->format('Y-m-d H:i:s'))->getResult();
        return $mails;
    }

    /**
     * Return MailQueue object - mail to send
     * Return null - nothing to send
     * @return MailQueue|null
     * @throws Exception
     */
    public function getNextMailToSend() {
        $mailQueue = $this->mailQueueRepository->findOneBy(['status' => MailQueue::STATUS_NEW], ['id'=>OrderBy::ORDER_ASC]);
        return $mailQueue;
    }
}
