<?php

namespace IZON\MailQueue\Repositories;


use Doctrine\ORM\Query;
use IZON\AppModules\IndividualPrices\Domain\IndividualPrice;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\DB\QueryParams\QueryParams;
use IZON\DB\Repository\BaseRepository;
use IZON\MailQueue\Domain\MailQueue;
use IZON\Utils\Date;


class MailQueueRepository extends BaseRepository {

    public function findOlderMailsThanInState(string $beforeDate, ?string $status = null) : Query {
        $mq = MailQueue::class;

        $statusWhere = "";
        if( $status !== null ) {
            $statusWhere = "AND mq.status = :$status";
        }

        $query = $this->getEntityManager()->createQuery("
            SELECT mq FROM $mq mq
            WHERE mq.date < :beforeDate
            ". $statusWhere ."
        ");
//        echo $query->getSQL(); die;
        return $query;
    }

}
