<?php

namespace IZON\MailQueue\Domain;

use Doctrine\ORM\Mapping as ORM;
use IZON\DB\DBObject;
use IZON\IO\FileInterface;
use IZON\IO\RasterImageInterface;
use IZON\Utils\Date;
use IZON\IO\Image;
use IZON\IO\File;

/**
 * @ORM\Entity()
 * @ORM\Table(name="core_mail_queue_attachments")
 * Description of MailQueueAttachment
 * @author IZON s.r.o. <info@izon.cz>
 */
class MailQueueAttachment {
    /**
     * @ORM\Column()
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @var null|int
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="MailQueue", inversedBy="attachments")
     * @ORM\JoinColumn(name="fk_mail_queue_id", referencedColumnName="id")
     * @var MailQueue
     */
    protected $mailQueue;

    /**
     * @ORM\Column(type="file")
     * @\IZON\DB\Files\Mapping\File(webVisible=false)
     * @var FileInterface
     */
    protected $attachment;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $name;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $encoding;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $type;


    public function __toString() {
        return "Id:`".$this->id."`".";"."FkMailQueueId:`".$this->fkMailQueueId."`".";"."Path:`".$this->attachment."`".";"."Name:`".$this->name."`".";"."Encoding:`".$this->encoding."`".";"."Type:`".$this->type."`";
    }

    /**
     * @return int
     */
    public function getId(): ?int {
        return $this->id;
    }

    /**
     * @param ?int $id
     */
    public function setId(int $id): void {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getEncoding(): string {
        return $this->encoding;
    }

    /**
     * @param string $encoding
     */
    public function setEncoding(string $encoding): void {
        $this->encoding = $encoding;
    }

    /**
     * @return string
     */
    public function getType(): string {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void {
        $this->type = $type;
    }

    /**
     * @return MailQueue
     */
    public function getMailQueue(): MailQueue {
        return $this->mailQueue;
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function setMailQueue(MailQueue $mailQueue): void {
        $this->mailQueue = $mailQueue;
    }

    /**
     * @return FileInterface
     */
    public function getAttachment(): FileInterface {
        return $this->attachment;
    }

    /**
     * @param FileInterface $attachment
     */
    public function setAttachment(FileInterface $attachment): void {
        $this->attachment = $attachment;
    }
}
