<?php

namespace IZON\MailQueue\DB;

use IZON\DB\QueryHelpers;
use IZON\MailQueue\Domain\MailQueue;

return [
    'findLockedById_1' => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $tableAlias = $queryHelpers->createTableAlias('mq');

            $query = "SELECT " . $queryHelpers->getClassProperties()
                ." FROM " . $tableAlias->getTableName()
                ." WHERE " . $tableAlias->getColumnName('id') . " = " . $queryHelpers->getParameterName(0)
                ." LIMIT :maxResults OFFSET :firstResult"
                ." FOR UPDATE";

            //echo $query;
            return $query;
        }
    ],

    'findMailsOlderThan_1' => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $tableAlias = $queryHelpers->createTableAlias('mq');

            $query = "SELECT DISTINCT " . $queryHelpers->getClassProperties()
                    ." FROM " . $tableAlias->getTableName()
                    ." WHERE " . $tableAlias->getColumnName('date') . " < " . $queryHelpers->getParameterName(0)
                    ." ORDER BY ". $tableAlias->getColumnName('id') ." ASC "
                    ." LIMIT :maxResults OFFSET :firstResult";

            //echo $query;
            return $query;
        }
    ],

    'customFindNextFailedMailToSend' => [
        'queryFactory' => function(QueryHelpers $queryHelpers, $params) {
            $tableAlias = $queryHelpers->createTableAlias('mq');

            $query = "
                SELECT DISTINCT {$queryHelpers->getClassProperties()}
                FROM {$tableAlias->getTableName()}
                WHERE {$tableAlias->getColumnName('date')} > {$queryHelpers->getParameterName('date')}
                    AND {$tableAlias->getColumnName('status')} IN ('".  implode("', '", MailQueue::FAILED_STATUSES) ."')
            ";

            if( array_key_exists('excluded', $params) ) {
                $query .= " AND ". $tableAlias->getColumnName('id') ." NOT IN(". $queryHelpers->getInParamersNames('excluded') .") ";
            }

            $query .= "
                ORDER BY mq.id ASC
                LIMIT :maxResults OFFSET :firstResult
            ";

//            echo $query; die;
            return $query;
        }
    ],

    'findMailsBetweenDatesInState_3' => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $mailQueue = $queryHelpers->createTableAlias('mq');
            $query = "
                SELECT DISTINCT {$mailQueue->getClassProperties()}
                FROM {$mailQueue->getTableName()}
                WHERE
                    {$mailQueue->getColumnName('date')}  >= {$queryHelpers->getParameterName(0)}
                    AND {$mailQueue->getColumnName('date')}  < {$queryHelpers->getParameterName(1)}
                    AND {$mailQueue->getColumnName('status')} = {$queryHelpers->getParameterName(2)}
                ORDER BY {$mailQueue->getColumnName('date')} ASC
                LIMIT :maxResults OFFSET :firstResult
            ";
            //echo $query;
            return $query;
        }
    ],
];
