CREATE TABLE `core_mail_queues` (
                                    `id` bigint NOT NULL,
                                    `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                    `from_mail` json NOT NULL,
                                    `to_mails` json NOT NULL,
                                    `reply_to_mails` json NOT NULL,
                                    `status` enum('new','sending','sent','send-failed','failed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                                    `status_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                                    `subject` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                    `html` tinyint(1) NOT NULL,
                                    `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                                    `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                    `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `core_mail_queue_attachments`
--

CREATE TABLE `core_mail_queue_attachments` (
                                               `id` bigint NOT NULL,
                                               `fk_mail_queue_id` bigint NOT NULL,
                                               `attachment` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
                                               `cid` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
                                               `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
                                               `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                               `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexy pro exportované tabulky
--

--
-- Indexy pro tabulku `core_mail_queues`
--
ALTER TABLE `core_mail_queues`
    ADD PRIMARY KEY (`id`);

--
-- Indexy pro tabulku `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
    ADD PRIMARY KEY (`id`),
    ADD KEY `fk_mail_queue_id` (`fk_mail_queue_id`);

--
-- AUTO_INCREMENT pro tabulky
--

--
-- AUTO_INCREMENT pro tabulku `core_mail_queues`
--
ALTER TABLE `core_mail_queues`
    MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pro tabulku `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
    MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- Omezení pro exportované tabulky
--

--
-- Omezení pro tabulku `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
    ADD CONSTRAINT `core_mail_queue_attachments_ibfk_1` FOREIGN KEY (`fk_mail_queue_id`) REFERENCES `core_mail_queues` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
