<?php

namespace IZON\MailQueue\Task\DTO;

use IZON\MailQueue\Domain\MailQueue;

class MailQueueStatus {

    /**
     * email was sent correctly
     */
    const STATUS_SKIPPED = 'skipped';

    /**
     * email was sent correctly
     */
    const STATUS_SENT = MailQueue::STATUS_SENT;

    /**
     *
     */
    const STATUS_SEND_FAILED = MailQueue::STATUS_SEND_FAILED;


    const STATUS_FAILED = MailQueue::STATUS_FAILED;

    protected int $queueMailId;

    /**
     * @var string
     */
    protected string $status;

    /**
     * @var string
     */
    protected string $statusText;


    /**
     * @param int $queueMailId
     * @param string $status
     * @param string $statusText
     */
    public function __construct(int $queueMailId, string $status, string $statusText) {
        $this->queueMailId = $queueMailId;
        $this->status = $status;
        $this->statusText = $statusText;
    }

    /**
     * @return int
     */
    public function getQueueMailId(): int {
        return $this->queueMailId;
    }

    /**
     * @return string
     */
    public function getStatus(): string {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getStatusText(): string {
        return $this->statusText;
    }

}
