<?php

namespace IZON\MailQueue;


use IZON\Mailer\Mail;
use IZON\Mailer\Mailer;
use IZON\MailQueue\Services\MailQueueService;


class QueueMailer implements Mailer {

    protected MailQueueService $mailQueueService;


    public function __construct(
        MailQueueService $mailQueueService
    ) {
        $this->mailQueueService = $mailQueueService;
    }


    /**
     * @param Mail $mail
     * @throws Exceptions\MailQueueException
     */
    public function sendMail(Mail $mail) {
        $this->mailQueueService->send($mail);
    }
}
