<?php

namespace IZON\MailQueue\Dao;

use IZON\DB\Dao;
use IZON\DB\QueryResult;
use IZON\MailQueue\Domain\MailQueue;

interface MailQueueDao extends Dao {

    /**
     * pro jakou tridu se toto dao pouziva
     */
    const DOMAIN_CLASS = MailQueue::class;

    /**
     * @param int $id
     * @return QueryResult
     */
    public function findLockedById(int $id): QueryResult;

    /**
     * @param array $params
     * @return QueryResult
     */
    public function customFindNextFailedMailToSend(array $params): QueryResult;

    /**
     * @param string $date  date in string Y-m-d H:i:s
     * @return QueryResult
     */
    public function findMailsOlderThan(string $date): QueryResult;

}