<?php

namespace IZON\MailQueue\Task\Services;

use Exception;
use IZON\DB\OrderBy;
use IZON\MailQueue\Domain\MailQueue;
use IZON\MailQueue\Services\BaseMailQueueService;
use IZON\Utils\Date;

class MailQueueService extends BaseMailQueueService {

    /**
     * @param Date $date
     * @param string $state
     * @return MailQueue[]
     * @throws Exception
     */
    public function getOlderMailsThanInState(Date $date, string $state) {
        $mails = $this->mailQueueDao->findOlderMailsThanInState($date->format('Y-m-d H:i:s'), $state)->listResult();
        foreach($mails as $mail){
            $this->fill($mail);
        }
        return $mails;
    }

    /**
     * @param MailQueue[] $mails
     */
    public function deleteMails(array $mails) {
        foreach($mails as $mail) {
            $this->delete($mail);
        }
    }

    /**
     * Return MailQueue object - mail to send
     * Return null - nothing to send
     * @return MailQueue|null
     * @throws Exception
     */
    public function getNextMailToSend() {
        $mailQueue = $this->mailQueueDao->find(['status' => MailQueue::STATUS_NEW], ['id'=>OrderBy::ASC])->setMaxResults(1)->uniqueResult();
        if( empty($mailQueue) ) {
            return null;
        }
        $this->fill($mailQueue);
        return $mailQueue;
    }
}