<?php

namespace IZON\MailQueue\Domain;


use IZON\DB\DBObject;
use IZON\Utils\Date;
use IZON\IO\Image;
use IZON\IO\File;


/**
 * Description of MailQueueAttachment
 * @author IZON s.r.o. <info@izon.cz>
 */
class MailQueueAttachment implements DBObject {
    /**
     *
     * @var integer
     */
    protected $id;

    /**
     * @var int
     */
    protected $fkMailQueueId;

    /**
     * @var File
     */
    protected $attachment;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var null|string
     */
    protected $cid;


    public function __construct() {
    }

    /**
     *
     */
    public static function __tableName() {
        return 'core_mail_queue_attachments';
    }

    /**
     * @return int
     */
    public function getId(): int {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getFkMailQueueId(): int {
        return $this->fkMailQueueId;
    }

    /**
     * @param int $fkMailQueueId
     */
    public function setFkMailQueueId(int $fkMailQueueId): void {
        $this->fkMailQueueId = $fkMailQueueId;
    }

    /**
     * @return File
     */
    public function getAttachment(): File {
        return $this->attachment;
    }

    /**
     * @param File $attachment
     */
    public function setAttachment(File $attachment): void {
        $this->attachment = $attachment;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void {
        $this->name = $name;
    }

    /**
     * @return string|null
     */
    public function getCid(): ?string {
        return $this->cid;
    }

    /**
     * @param string|null $cid
     */
    public function setCid(?string $cid): void {
        $this->cid = $cid;
    }
}
