<?php

namespace IZON\MailQueue;


use IZON\Mailer\Mail;
use IZON\Mailer\Mailer;
use IZON\MailQueue\Domain\MailQueue;
use IZON\MailQueue\Domain\MailQueueAttachment;
use IZON\MailQueue\Exceptions\MailQueueException;
use IZON\MailQueue\Services\BaseMailQueueService;
use function IZON\Object\createGetterMethodName;

class QueueMailer implements Mailer {

    /**
     * @var BaseMailQueueService
     */
    protected $mailQueueService;

    /**
     * QueueMailer constructor.
     * @param BaseMailQueueService $mailQueueService
     */
    public function __construct(BaseMailQueueService $mailQueueService) {
        $this->mailQueueService = $mailQueueService;
    }


    /**
     * @param Mail $mail
     * @throws Exceptions\MailQueueException
     */
    public function sendMail(Mail $mail) {
        $queue = $this->createQueueMail($mail);
        $queue->setStatus(MailQueue::STATUS_NEW);
        $this->mailQueueService->save($queue);
    }

    /**
     * Create queue mail by mail
     * @param Mail $mail
     * @return MailQueue
     * @throws Exceptions\MailQueueException
     */
    protected function createQueueMail(Mail $mail){
        $queue = new MailQueue();
        if(empty($mail->getFrom())){
            throw new MailQueueException('Sender of mail can not be empty');
        }
        $queue->setFromMail($mail->getFrom()['email'], (is_null($mail->getFrom()['name'])? '': $mail->getFrom()['name']));
        if(empty($mail->getSubject())){
            $queue->setSubject("");
        }else {
            $queue->setSubject($mail->getSubject());
        }
        if(empty($mail->getBody())){
            $queue->setContent("");
        }else {
            $queue->setContent($mail->getBody());
        }
        $queue->setHtml($mail->isHtml());
        foreach($mail->getReplyTo() as $to){
            $queue->addReplyToMails($to['email'], (is_null($to['name']) ? '' : $to['name']));
        }
        foreach($mail->getTo() as $to){
            $queue->addToMail($to['email'], (is_null($to['name']) ? '' : $to['name']));
        }
        foreach($mail->getAttachments() as $attachment){
            $queueAttachment = new MailQueueAttachment();
            $queueAttachment->setName($attachment["name"]);
            $queueAttachment->setPath($attachment["path"]);
            $queueAttachment->setEncoding($attachment["encoding"]);
            $queueAttachment->setType($attachment["type"]);
            $queue->addAttachment($queueAttachment);
        }
        return $queue;
    }
}