<?php

namespace IZON\MailQueue\Services;


use IZON\DB\OrderBy;
use IZON\MailQueue\Dao\MailQueueAttachmentDao;
use IZON\MailQueue\Dao\MailQueueDao;
use IZON\MailQueue\Domain\MailQueue;
use IZON\Utils\Date;

class BaseMailQueueService {

    /**
     * @var MailQueueDao
     */
    protected $mailQueueDao;
    /**
     * @var MailQueueAttachmentDao
     */
    protected $mailQueueAttachmentDao;

    /**
     * BaseMailQueueService constructor.
     * @param MailQueueDao $mailQueueDao
     * @param MailQueueAttachmentDao $mailQueueAttachmentDao
     */
    public function __construct(MailQueueDao $mailQueueDao, MailQueueAttachmentDao $mailQueueAttachmentDao) {
        $this->mailQueueDao = $mailQueueDao;
        $this->mailQueueAttachmentDao = $mailQueueAttachmentDao;
    }

    /**
     * @param MailQueue $mailQueue
     */
    protected function fill(MailQueue $mailQueue){
        $attachements = $this->mailQueueAttachmentDao->find(['fkMailQueueId' => $mailQueue->getId()])->listResult();
        $mailQueue->setAttachments($attachements);
    }

    /**
     * @param $id
     * @return MailQueue
     */
    public function get($id){
        $mailQueue = $this->mailQueueDao->load($id);
        $this->fill($mailQueue);
        return $mailQueue;
    }

    /**
     * @return MailQueue[]
     */
    public function getAllNewInQueue(){
        $mailQueue = $this->mailQueueDao->find(['status' => MailQueue::STATUS_NEW])->listResult();
        foreach($mailQueue as $item) {
            $this->fill($item);
        }
        return $mailQueue;
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function save(MailQueue $mailQueue){
        $this->mailQueueDao->beginTransaction();
        $mailQueue->setDate(new Date());
        $this->mailQueueDao->save($mailQueue);
        foreach($mailQueue->getAttachments() as $item){
            $item->setFkMailQueueId($mailQueue->getId());
            $this->mailQueueAttachmentDao->save($item);
        }
        $this->mailQueueDao->commit();
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function update(MailQueue $mailQueue){
        $this->mailQueueDao->beginTransaction();
        $this->mailQueueDao->update($mailQueue);
        $this->updateAttachmentObjects($mailQueue);
        $this->mailQueueDao->commit();
    }

    /**
     * @param MailQueue $mailQueue
     */
    public function delete(MailQueue $mailQueue){
        $this->mailQueueDao->beginTransaction();
        $mailQueue->setAttachments([]);
        $this->updateAttachmentObjects($mailQueue);
        $this->mailQueueDao->delete($mailQueue);
        $this->mailQueueDao->commit();
    }

    /**
     * To update attachment - without transation
     * @param MailQueue $mailQueue
     */
    protected function updateAttachmentObjects(MailQueue $mailQueue){
        $olds = $this->mailQueueAttachmentDao->find(['fkMailQueueId' => $mailQueue->getId()])->listResult();
        $oldsHash = [];
        foreach($olds as $old){
            $oldsHash[$old->getId()] = $old;
        }
        foreach($mailQueue->getAttachments() as $object){
            if(isset($oldsHash[$object->getId()])){
                unset($oldsHash[$object->getId()]);
            }else{
                $object->setFkMailQueueId($mailQueue->getId());
                $this->mailQueueAttachmentDao->save($object);
            }
        }
        foreach($oldsHash as $toDelete){
            $this->mailQueueAttachmentDao->delete($toDelete);
        }
    }


}