<?php

namespace IZON\MailQueue\Task;


use IZON\Logs\Logger;
use IZON\Mailer\Mail;
use IZON\Mailer\Mailer;
use IZON\MailQueue\Domain\MailQueue;
use IZON\MailQueue\Services\BaseMailQueueService;
use IZON\Tasks\BaseTasks\DatabaseLoggedTask;
use IZON\Tasks\Services\ITaskWatchdogService;
use IZON\Tasks\Task;
use PHPMailer\PHPMailer\Exception;


class QueueMailSenderTask extends DatabaseLoggedTask{

    /**
     * @var Mailer
     */
    protected $mailer;
    /**
     * @var BaseMailQueueService
     */
    protected $service;
    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var int Limit of sended mail per one run of task
     */
    protected $limitOfMailOnRun = 100;

    /**
     * @param Mailer $mailer
     */
    public function setMailer(Mailer $mailer) {
        $this->mailer = $mailer;
    }

    /**
     * @param BaseMailQueueService $service
     */
    public function setService(BaseMailQueueService $service) {
        $this->service = $service;
    }

    /**
     * @param int $limitOfMailOnRun
     */
    public function setLimitOfMailOnRun(int $limitOfMailOnRun) {
        $this->limitOfMailOnRun = $limitOfMailOnRun;
    }

    /**
     * @param array $args
     * @throws \IZON\MailQueue\Exceptions\MailQueueException
     */
    public function runTask(array $args) {
        //TODO: try to resend mails in faild state
        for($i=0; $i < $this->limitOfMailOnRun; $i++){
            try {
                $queueMail = $this->service->getNextMailToSend();
                if(empty($queueMail)){
                    break;
                }
            }catch(\Exception $e){
                $this->getLogger()->error('Some mail send fail', ['exception' => $e]);
                continue;
            }
            try {
                $queueMail->setStatus(MailQueue::STATUS_SENDING);
                $this->service->update($queueMail);
                $mail = $this->createMailObject($queueMail);
                $this->mailer->sendMail($mail);
                $queueMail->setStatus(MailQueue::STATUS_SENDED);
                $this->service->update($queueMail);
            }catch(\Exception $exception){
                $queueMail->setStatus(MailQueue::STATUS_FAIL);
                $queueMail->setStatusText($exception->getMessage());
                $this->service->update($queueMail);
                $this->getLogger()->error('Send mail id:' . $queueMail->getId() . " fail", ['exception' => $exception]);
                continue;
            }
        }
    }

    /**
     * @param MailQueue $mailQueue
     * @return Mail
     * @throws \IZON\MailQueue\Exceptions\MailQueueException
     */
    protected function createMailObject(MailQueue $mailQueue) {
        $mail = new Mail();
        $mail->setSubject($mailQueue->getSubject());
        $mail->setHtml($mailQueue->isHtml());
        $mail->setFrom($mailQueue->getFromMail(), $mailQueue->getFromName());
        $mail->setBody($mailQueue->getContent());
        foreach($mailQueue->getToMails() as $to){
            if(!is_array($to)) {
                continue;
            }
            $name = $to['name'];
            $email = $to['email'];
            $mail->addTo($email,$name);
        }
        if(!empty($mailQueue->getReplyToMails())) {
            foreach($mailQueue->getReplyToMails() as $to) {
                if(!is_array($to)) {
                    continue;
                }
                $name = $to['name'];
                $email = $to['email'];
                $mail->addTo($email, $name);
            }
        }
        foreach($mailQueue->getAttachments() as $attachment){
            $mail->addAttachment($attachment->getPath(),$attachment->getName(), $attachment->getType(), $attachment->getEncoding());
        }
        return $mail;
    }

    /**
     * @return Logger
     */
    protected function getLogger(){
        if(empty($this->logger)){
            $this->logger = Logger::getLogger(self::class);
        }
        return $this->logger;
    }


}