CREATE TABLE `core_mail_queue` (
  `id` bigint(20) NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `html` tinyint(1) NOT NULL,
  `from_mail` varchar(1024) COLLATE utf8_unicode_ci NOT NULL,
  `to_mails` text COLLATE utf8_unicode_ci NOT NULL,
  `reply_to_mails` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('new','sended','failSend','fail') COLLATE utf8_unicode_ci NOT NULL,
  `status_text` text COLLATE utf8_unicode_ci,
  `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `core_mail_queue_attachments`
--

CREATE TABLE `core_mail_queue_attachments` (
  `id` bigint(20) NOT NULL,
  `fk_mail_queue_id` bigint(20) NOT NULL,
  `path` varchar(1024) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `encoding` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `create_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `core_mail_queue`
--
ALTER TABLE `core_mail_queue`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_mail_queue_id` (`fk_mail_queue_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `core_mail_queue`
--
ALTER TABLE `core_mail_queue`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;
--
-- Constraints for dumped tables
--

--
-- Constraints for table `core_mail_queue_attachments`
--
ALTER TABLE `core_mail_queue_attachments`
  ADD CONSTRAINT `core_mail_queue_attachments_ibfk_1` FOREIGN KEY (`fk_mail_queue_id`) REFERENCES `core_mail_queue` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
