<?php

namespace IZON\MailQueue\Domain;

use IZON\DB\DBObject;
use IZON\Utils\Date;
use IZON\IO\Image;
use IZON\IO\File;

/**
 * Description of MailQueueAttachment
 * @author IZON s.r.o. <info@izon.cz>
 */
class MailQueueAttachment implements DBObject {
    /**
     *
     * @var integer
     */
    protected $id;
    /**
     *
     * @var integer
     */
    protected $fkMailQueueId;
    /**
     *
     * @var string
     */
    protected $path;
    /**
     *
     * @var string
     */
    protected $name;
    /**
     *
     * @var string
     */
    protected $encoding;
    /**
     *
     * @var string
     */
    protected $type;


    public function __construct() {
    }

    /**
     *
     */
    public static function __tableName() {
        return 'core_mail_queue_attachments';
    }

    public function __toString() {
        return "Id:`".$this->id."`".";"."FkMailQueueId:`".$this->fkMailQueueId."`".";"."Path:`".$this->path."`".";"."Name:`".$this->name."`".";"."Encoding:`".$this->encoding."`".";"."Type:`".$this->type."`";
    }

    /**
     * @return int
     */
    public function getId(): int {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getFkMailQueueId(): int {
        return $this->fkMailQueueId;
    }

    /**
     * @param int $fkMailQueueId
     */
    public function setFkMailQueueId(int $fkMailQueueId): void {
        $this->fkMailQueueId = $fkMailQueueId;
    }

    /**
     * @return string
     */
    public function getPath(): string {
        return $this->path;
    }

    /**
     * @param string $path
     */
    public function setPath(string $path): void {
        $this->path = $path;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getEncoding(): string {
        return $this->encoding;
    }

    /**
     * @param string $encoding
     */
    public function setEncoding(string $encoding): void {
        $this->encoding = $encoding;
    }

    /**
     * @return string
     */
    public function getType(): string {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void {
        $this->type = $type;
    }


}
