<?php

namespace IZON\MailQueue\Task;


use IZON\Logs\Logger;
use IZON\Mailer\Mail;
use IZON\Mailer\Mailer;
use IZON\MailQueue\Domain\MailQueue;
use IZON\MailQueue\Services\BaseMailQueueService;
use IZON\Tasks\BaseTasks\DatabaseLoggedTask;
use IZON\Tasks\Services\ITaskWatchdogService;
use IZON\Tasks\Task;


class QueueMailSenderTask implements Task{

    /**
     * @var Mailer
     */
    protected $mailer;
    /**
     * @var BaseMailQueueService
     */
    protected $service;
    /**
     * @var Logger
     */
    protected $logger;

    /**
     * QueueMailSenderTask constructor.
     * @param Mailer $mailer
     * @param BaseMailQueueService $service
     */
    public function __construct(Mailer $mailer, BaseMailQueueService $service) {
        $this->mailer = $mailer;
        $this->service = $service;
        $this->logger = Logger::getLogger(self::class);
    }

    /**
     * @param array $args
     * @throws \IZON\MailQueue\Exceptions\MailQueueException
     */
    public function run(array $args) {
        $queueMails = $this->service->getAllNewInQueue();
        //TODO: try to resend mails in faild state
        foreach($queueMails as $queueMail){
            try {
                $mail = $this->createMailObject($queueMail);
                $this->mailer->sendMail($mail);
                $queueMail->setStatus(MailQueue::STATUS_SENDED);
                $this->service->update($queueMail);
            }catch(\Exception $exception){
                $queueMail->setStatus(MailQueue::STATUS_FAIL);
                $queueMail->setStatusText($exception->getMessage());
                $this->service->update($queueMail);
                $this->logger->error('Send mail id:' . $queueMail->getId() . " fail", ['exception' => $exception]);
            }
        }
    }

    /**
     * @param MailQueue $mailQueue
     * @return Mail
     * @throws \IZON\MailQueue\Exceptions\MailQueueException
     */
    protected function createMailObject(MailQueue $mailQueue) {
        $mail = new Mail();
        $mail->setSubject($mailQueue->getSubject());
        $mail->setHtml($mailQueue->isHtml());
        $mail->setFrom($mailQueue->getFromMail(), $mailQueue->getFromName());
        $mail->setBody($mailQueue->getContent());
        foreach($mailQueue->getToMails() as $to){
            if(!is_array($to)) {
                continue;
            }
            $name = $to['name'];
            $email = $to['email'];
            $mail->addTo($email,$name);
        }
        if(!empty($mailQueue->getReplyToMails())) {
            foreach($mailQueue->getReplyToMails() as $to) {
                if(!is_array($to)) {
                    continue;
                }
                $name = $to['name'];
                $email = $to['email'];
                $mail->addTo($email, $name);
            }
        }
        foreach($mailQueue->getAttachments() as $attachment){
            $mail->addAttachment($attachment->getPath(),$attachment->getName(), $attachment->getType(), $attachment->getEncoding());
        }
        return $mail;
    }


}