<?php

namespace IZON\Logs\Tests;

use IZON\Logs\LoggerRegistry;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Logger;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;

class LoggerRegistryTest extends TestCase
{
    /**
     * channel name must be provided to distinguish message sources
     */
    public function testNoLoggerChannelProvided(): void
    {
        $this->expectException(\ArgumentCountError::class);
        LoggerRegistry::getLogger(); // @phpstan-ignore-line
    }

    /**
     * chovani pro neinicializovane registry
     * dafautni nastaveni netaha z zadneho souboru ale inicializuje si interne
     */
    public function testUninitialized(): void
    {
        LoggerRegistry::clearRegistry();

        $logger = LoggerRegistry::getLogger(LoggerRegistry::DEFAULT_CHANNEL);
        $this->assertInstanceOf(LoggerInterface::class, $logger); // @phpstan-ignore method.alreadyNarrowedType
        $this->assertInstanceOf(Logger::class, $logger);
        $this->assertCount(1, $logger->getHandlers());
        $this->assertInstanceOf(ErrorLogHandler::class, $logger->getHandlers()[0]);
    }

    /**
     * chovani pro neinicializovane registry
     */
    public function testClearRegistry(): void
    {
        LoggerRegistry::clearRegistry();
        $this->assertTrue(true);  // @phpstan-ignore method.alreadyNarrowedType
    }
}
