<?php

namespace IZON\Logs;

use Monolog\Handler\ErrorLogHandler;
use Monolog\Logger;
use Monolog\Registry;
use Psr\Log\LoggerInterface;

/**
 * Třída pro získávání loggeru
 * Třáda musí mít defaultní logger, který je k dizpozici pokud by někdo chtěl logger
 * před inicializací loggerů podle konfigurace nebo se inializace nepovedla / nebyla spuštěna,
 * defaltní logger je inicialzací přepsán
 *
 * třída je zapozdřená svůj vnitrřní stav mení jen ONA SAMA, není možne ji z boku ovlivňovat
 *
 * test dodám jak bude chvilka
 */
class LoggerRegistry
{
    public const DEFAULT_CHANNEL = 'default';

    protected static ?Registry $registry = null;


    protected static function getInstance(): Registry
    {
        if (!self::$registry instanceof Registry) {
            self::$registry = new Registry();
        }
        return self::$registry;
    }

    public static function clearRegistry(): void
    {
        if (self::$registry instanceof Registry) {
            self::$registry::clear();
        }
    }

    public static function addLogger(string $channel, Logger $logger): void
    {
        $registry = self::getInstance();
        $registry::addLogger($logger, $channel);
    }

    /**
     * if logger with $channelName initialized from config, return it
     * if logger with $channelName not initialized, return default logger
     * @param string $channelName
     * @return LoggerInterface
     */
    public static function getLogger(string $channelName): LoggerInterface
    {
        $registry = self::getInstance();

        if ($registry::hasLogger($channelName)) { // $channelName logger exists
            return $registry::getInstance($channelName);
        }

        // create default logger if not exists yet
        if (!$registry::hasLogger(self::DEFAULT_CHANNEL)) {
            $logger = self::createFallbackLogger(self::DEFAULT_CHANNEL);
            $registry::addLogger($logger);
        }

        if ($channelName !== self::DEFAULT_CHANNEL) {
            $defaultLogger = $registry::getInstance(self::DEFAULT_CHANNEL);
            $logger = $defaultLogger->withName($channelName);
            $registry::addLogger($logger, $channelName);
            return $logger;
        }

        return $registry::getInstance(self::DEFAULT_CHANNEL);
    }

    /**
     * creates simple logger
     * @param string $name
     * @return Logger
     */
    protected static function createFallbackLogger(string $name): Logger
    {
        $logger = new Logger($name);
        $logger->pushHandler(new ErrorLogHandler());
        return $logger;
    }
}
