<?php

namespace IZON\Logs\Handlers;

use Monolog\Handler\StreamHandler;

/**
 * echo log to standard output
 *
 * @author lukas
 */
class EchoHandler extends StreamHandler
{
    public function __construct()
    {
        parent::__construct('php://output');
    }

    /**
     * Write to stream
     * @param resource $stream
     * @param array $record
     */
    protected function streamWrite($stream, array $record)
    {
        fwrite($stream, "<pre>\n" . (string)$record['formatted'] . "</pre>\n");
    }
}
