<?php

namespace IZON\Logs\Appenders;

use IZON\Logs\DataAppenderInterface;
use IZON\Logs\Exceptions\UserAgentParseException;
use IZON\Logs\Utils\UserAgent;

/**
 * add user agent data to log context
 */
class UserAgentDataAppender implements DataAppenderInterface
{
    protected bool $initialized = false;

    protected ?UserAgent $userAgent = null;

    /**
     * append user agent
     * @param array<string, mixed> $context
     * @return array<string, mixed>
     */
    public function append(array $context): array
    {
        // user agent string if present
        $agentString = filter_input(INPUT_SERVER, 'HTTP_USER_AGENT');
        if (!empty($agentString)) {
            $context['contexts']['user_agent'] = $agentString;
        }
        // try to parse user agent data
        if (!empty($this->getUserAgent())) {
            $context['contexts']['browser'] = [
                'name' => $this->getUserAgent()->getBrowserName(),
                'version' => $this->getUserAgent()->getBrowserVersion(),
            ];
            $context['contexts']['os'] = ['name' => $this->getUserAgent()->getPlatform()];
        }
        // add ip address if present
        if (
            array_key_exists('REMOTE_ADDR', $_SERVER)
            && !empty($_SERVER['REMOTE_ADDR'])
        ) {
            $context['contexts']['ip'] = $_SERVER['REMOTE_ADDR'];
        }

        return $context;
    }

    /**
     * get user agent of current request
     * @return UserAgent|null
     */
    protected function getUserAgent(): ?UserAgent
    {
        if (!$this->initialized) {
            $agentString = filter_input(INPUT_SERVER, 'HTTP_USER_AGENT');
            if (!empty($agentString)) {
                try {
                    $this->userAgent = new UserAgent($agentString);
                } catch (UserAgentParseException $ex) {
                    $this->userAgent = null;
                }
            }
            $this->initialized = true;
        }
        return $this->userAgent;
    }
}
